package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 公司服务包Request
 */
@ApiModel(description = "公司服务包Request")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class GetContractServiceDetailRequest   {
    @JsonProperty("contractId")
    private String contractId = null;

    @JsonProperty("id")
    private String id = null;

    @JsonProperty("page")
    private String page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private String row = null;

    @JsonProperty("status")
    private String status = null;

    public GetContractServiceDetailRequest withContractId(String contractId) {
        this.contractId = contractId;
        return this;
    }

    /**
    * 合同主键
    * @return contractId
    **/
    @ApiModelProperty(value = "合同主键")


    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public GetContractServiceDetailRequest withId(String id) {
        this.id = id;
        return this;
    }

    /**
    * 公司服务包主键
    * @return id
    **/
    @ApiModelProperty(value = "公司服务包主键")


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public GetContractServiceDetailRequest withPage(String page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public GetContractServiceDetailRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * rid
    * @return rid
    **/
    @ApiModelProperty(value = "rid")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public GetContractServiceDetailRequest withRow(String row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public GetContractServiceDetailRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 状态： 1：启用 0：注销
    * @return status
    **/
    @ApiModelProperty(value = "状态： 1：启用 0：注销")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetContractServiceDetailRequest getContractServiceDetailRequest = (GetContractServiceDetailRequest) o;
        return Objects.equals(this.contractId, getContractServiceDetailRequest.contractId) &&
            Objects.equals(this.id, getContractServiceDetailRequest.id) &&
            Objects.equals(this.page, getContractServiceDetailRequest.page) &&
            Objects.equals(this.rid, getContractServiceDetailRequest.rid) &&
            Objects.equals(this.row, getContractServiceDetailRequest.row) &&
            Objects.equals(this.status, getContractServiceDetailRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(contractId, id, page, rid, row, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GetContractServiceDetailRequest }.
     */
    public static GetContractServiceDetailRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GetContractServiceDetailRequest.class);
    }
}

