package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 企业审核Request
 */
@ApiModel(description = "企业审核Request")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class GetDeviceApplyListRequest   {
    @JsonProperty("deviceNo")
    private String deviceNo = null;

    @JsonProperty("page")
    private String page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private String row = null;

    @JsonProperty("status")
    private String status = null;

    public GetDeviceApplyListRequest withDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
        return this;
    }

    /**
    * 设备编号
    * @return deviceNo
    **/
    @ApiModelProperty(value = "设备编号")


    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public GetDeviceApplyListRequest withPage(String page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public GetDeviceApplyListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public GetDeviceApplyListRequest withRow(String row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public GetDeviceApplyListRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭）
    * @return status
    **/
    @ApiModelProperty(value = "设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭）")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetDeviceApplyListRequest getDeviceApplyListRequest = (GetDeviceApplyListRequest) o;
        return Objects.equals(this.deviceNo, getDeviceApplyListRequest.deviceNo) &&
            Objects.equals(this.page, getDeviceApplyListRequest.page) &&
            Objects.equals(this.rid, getDeviceApplyListRequest.rid) &&
            Objects.equals(this.row, getDeviceApplyListRequest.row) &&
            Objects.equals(this.status, getDeviceApplyListRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deviceNo, page, rid, row, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GetDeviceApplyListRequest }.
     */
    public static GetDeviceApplyListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GetDeviceApplyListRequest.class);
    }
}

