package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 集团Request
 */
@ApiModel(description = "集团Request")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class GetGroupListRequest   {
    @JsonProperty("defaultFlag")
    private String defaultFlag = null;

    @JsonProperty("groupName")
    private String groupName = null;

    @JsonProperty("page")
    private String page = null;

    @JsonProperty("queryCompanyCountFlag")
    private String queryCompanyCountFlag = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private String row = null;

    @JsonProperty("status")
    private String status = null;

    public GetGroupListRequest withDefaultFlag(String defaultFlag) {
        this.defaultFlag = defaultFlag;
        return this;
    }

    /**
    * 是否缺省集团 1：是 0：否
    * @return defaultFlag
    **/
    @ApiModelProperty(value = "是否缺省集团 1：是 0：否")


    public String getDefaultFlag() {
        return defaultFlag;
    }

    public void setDefaultFlag(String defaultFlag) {
        this.defaultFlag = defaultFlag;
    }

    public GetGroupListRequest withGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    /**
    * 集团名称
    * @return groupName
    **/
    @ApiModelProperty(value = "集团名称")


    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public GetGroupListRequest withPage(String page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public GetGroupListRequest withQueryCompanyCountFlag(String queryCompanyCountFlag) {
        this.queryCompanyCountFlag = queryCompanyCountFlag;
        return this;
    }

    /**
    * 是否查询公司数量： 1：查询 默认不查询
    * @return queryCompanyCountFlag
    **/
    @ApiModelProperty(value = "是否查询公司数量： 1：查询 默认不查询")


    public String getQueryCompanyCountFlag() {
        return queryCompanyCountFlag;
    }

    public void setQueryCompanyCountFlag(String queryCompanyCountFlag) {
        this.queryCompanyCountFlag = queryCompanyCountFlag;
    }

    public GetGroupListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public GetGroupListRequest withRow(String row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public GetGroupListRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 状态： 1：启用 0：注销
    * @return status
    **/
    @ApiModelProperty(value = "状态： 1：启用 0：注销")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetGroupListRequest getGroupListRequest = (GetGroupListRequest) o;
        return Objects.equals(this.defaultFlag, getGroupListRequest.defaultFlag) &&
            Objects.equals(this.groupName, getGroupListRequest.groupName) &&
            Objects.equals(this.page, getGroupListRequest.page) &&
            Objects.equals(this.queryCompanyCountFlag, getGroupListRequest.queryCompanyCountFlag) &&
            Objects.equals(this.rid, getGroupListRequest.rid) &&
            Objects.equals(this.row, getGroupListRequest.row) &&
            Objects.equals(this.status, getGroupListRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(defaultFlag, groupName, page, queryCompanyCountFlag, rid, row, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GetGroupListRequest }.
     */
    public static GetGroupListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GetGroupListRequest.class);
    }
}

