package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * OpenApiUserRequest
 */
@ApiModel(description = "OpenApiUserRequest")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class GetOpenApiUserListRequest   {
    @JsonProperty("openapiUserObject")
    private String openapiUserObject = null;

    @JsonProperty("page")
    private String page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private String row = null;

    @JsonProperty("status")
    private String status = null;

    @JsonProperty("userCode")
    private String userCode = null;

    public GetOpenApiUserListRequest withOpenapiUserObject(String openapiUserObject) {
        this.openapiUserObject = openapiUserObject;
        return this;
    }

    /**
    * 对象
    * @return openapiUserObject
    **/
    @ApiModelProperty(value = "对象")


    public String getOpenapiUserObject() {
        return openapiUserObject;
    }

    public void setOpenapiUserObject(String openapiUserObject) {
        this.openapiUserObject = openapiUserObject;
    }

    public GetOpenApiUserListRequest withPage(String page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public GetOpenApiUserListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * rid
    * @return rid
    **/
    @ApiModelProperty(value = "rid")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public GetOpenApiUserListRequest withRow(String row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public GetOpenApiUserListRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 状态： 1：启用 2：禁用 3：关闭
    * @return status
    **/
    @ApiModelProperty(value = "状态： 1：启用 2：禁用 3：关闭")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public GetOpenApiUserListRequest withUserCode(String userCode) {
        this.userCode = userCode;
        return this;
    }

    /**
    * 人员代码/账号
    * @return userCode
    **/
    @ApiModelProperty(value = "人员代码/账号")


    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetOpenApiUserListRequest getOpenApiUserListRequest = (GetOpenApiUserListRequest) o;
        return Objects.equals(this.openapiUserObject, getOpenApiUserListRequest.openapiUserObject) &&
            Objects.equals(this.page, getOpenApiUserListRequest.page) &&
            Objects.equals(this.rid, getOpenApiUserListRequest.rid) &&
            Objects.equals(this.row, getOpenApiUserListRequest.row) &&
            Objects.equals(this.status, getOpenApiUserListRequest.status) &&
            Objects.equals(this.userCode, getOpenApiUserListRequest.userCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(openapiUserObject, page, rid, row, status, userCode);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GetOpenApiUserListRequest }.
     */
    public static GetOpenApiUserListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GetOpenApiUserListRequest.class);
    }
}

