package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 服务包Request
 */
@ApiModel(description = "服务包Request")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class GetResourcesetListRequest   {
    @JsonProperty("hasResourceList")
    private String hasResourceList = null;

    @JsonProperty("page")
    private String page = null;

    @JsonProperty("resourcesetName")
    private String resourcesetName = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private String row = null;

    @JsonProperty("status")
    private String status = null;

    public GetResourcesetListRequest withHasResourceList(String hasResourceList) {
        this.hasResourceList = hasResourceList;
        return this;
    }

    /**
    * 是否获取资源码
    * @return hasResourceList
    **/
    @ApiModelProperty(value = "是否获取资源码")


    public String getHasResourceList() {
        return hasResourceList;
    }

    public void setHasResourceList(String hasResourceList) {
        this.hasResourceList = hasResourceList;
    }

    public GetResourcesetListRequest withPage(String page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public GetResourcesetListRequest withResourcesetName(String resourcesetName) {
        this.resourcesetName = resourcesetName;
        return this;
    }

    /**
    * 功能集名称
    * @return resourcesetName
    **/
    @ApiModelProperty(value = "功能集名称")


    public String getResourcesetName() {
        return resourcesetName;
    }

    public void setResourcesetName(String resourcesetName) {
        this.resourcesetName = resourcesetName;
    }

    public GetResourcesetListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * rid
    * @return rid
    **/
    @ApiModelProperty(value = "rid")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public GetResourcesetListRequest withRow(String row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public GetResourcesetListRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 状态： 1：启用 0：注销
    * @return status
    **/
    @ApiModelProperty(value = "状态： 1：启用 0：注销")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetResourcesetListRequest getResourcesetListRequest = (GetResourcesetListRequest) o;
        return Objects.equals(this.hasResourceList, getResourcesetListRequest.hasResourceList) &&
            Objects.equals(this.page, getResourcesetListRequest.page) &&
            Objects.equals(this.resourcesetName, getResourcesetListRequest.resourcesetName) &&
            Objects.equals(this.rid, getResourcesetListRequest.rid) &&
            Objects.equals(this.row, getResourcesetListRequest.row) &&
            Objects.equals(this.status, getResourcesetListRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(hasResourceList, page, resourcesetName, rid, row, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GetResourcesetListRequest }.
     */
    public static GetResourcesetListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GetResourcesetListRequest.class);
    }
}

