package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 服务包Request
 */
@ApiModel(description = "服务包Request")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class GetServicePackageListRequest   {
    @JsonProperty("page")
    private String page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private String row = null;

    @JsonProperty("servicePackageName")
    private String servicePackageName = null;

    @JsonProperty("status")
    private String status = null;

    public GetServicePackageListRequest withPage(String page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public GetServicePackageListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * rid
    * @return rid
    **/
    @ApiModelProperty(value = "rid")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public GetServicePackageListRequest withRow(String row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public GetServicePackageListRequest withServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
        return this;
    }

    /**
    * 服务包名称
    * @return servicePackageName
    **/
    @ApiModelProperty(value = "服务包名称")


    public String getServicePackageName() {
        return servicePackageName;
    }

    public void setServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
    }

    public GetServicePackageListRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 状态： 1：启用 0：注销
    * @return status
    **/
    @ApiModelProperty(value = "状态： 1：启用 0：注销")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetServicePackageListRequest getServicePackageListRequest = (GetServicePackageListRequest) o;
        return Objects.equals(this.page, getServicePackageListRequest.page) &&
            Objects.equals(this.rid, getServicePackageListRequest.rid) &&
            Objects.equals(this.row, getServicePackageListRequest.row) &&
            Objects.equals(this.servicePackageName, getServicePackageListRequest.servicePackageName) &&
            Objects.equals(this.status, getServicePackageListRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(page, rid, row, servicePackageName, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GetServicePackageListRequest }.
     */
    public static GetServicePackageListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GetServicePackageListRequest.class);
    }
}

