package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class GetTenantInfoRequest   {
    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("tenant_id")
    private String tenantId = null;

    public GetTenantInfoRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public GetTenantInfoRequest withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
    * 租户ID
    * @return tenantId
    **/
    @ApiModelProperty(value = "租户ID")


    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetTenantInfoRequest getTenantInfoRequest = (GetTenantInfoRequest) o;
        return Objects.equals(this.rid, getTenantInfoRequest.rid) &&
            Objects.equals(this.tenantId, getTenantInfoRequest.tenantId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(rid, tenantId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GetTenantInfoRequest }.
     */
    public static GetTenantInfoRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GetTenantInfoRequest.class);
    }
}

