package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 获取租户列表-分页
 */
@ApiModel(description = "获取租户列表-分页")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class GetTenantListRequest   {
    @JsonProperty("page")
    private String page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private String row = null;

    @JsonProperty("status")
    private String status = null;

    @JsonProperty("tenantEmail")
    private String tenantEmail = null;

    public GetTenantListRequest withPage(String page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public GetTenantListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public GetTenantListRequest withRow(String row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public GetTenantListRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 状态： 1：启用 0：注销
    * @return status
    **/
    @ApiModelProperty(value = "状态： 1：启用 0：注销")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public GetTenantListRequest withTenantEmail(String tenantEmail) {
        this.tenantEmail = tenantEmail;
        return this;
    }

    /**
    * 租户账号
    * @return tenantEmail
    **/
    @ApiModelProperty(value = "租户账号")


    public String getTenantEmail() {
        return tenantEmail;
    }

    public void setTenantEmail(String tenantEmail) {
        this.tenantEmail = tenantEmail;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GetTenantListRequest getTenantListRequest = (GetTenantListRequest) o;
        return Objects.equals(this.page, getTenantListRequest.page) &&
            Objects.equals(this.rid, getTenantListRequest.rid) &&
            Objects.equals(this.row, getTenantListRequest.row) &&
            Objects.equals(this.status, getTenantListRequest.status) &&
            Objects.equals(this.tenantEmail, getTenantListRequest.tenantEmail);
    }

    @Override
    public int hashCode() {
        return Objects.hash(page, rid, row, status, tenantEmail);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GetTenantListRequest }.
     */
    public static GetTenantListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GetTenantListRequest.class);
    }
}

