package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class GroupChangeStatusRequest   {
    @JsonProperty("groupId")
    private String groupId = null;

    @JsonProperty("operateReason")
    private String operateReason = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("status")
    private String status = null;

    @JsonProperty("updateTime")
    private String updateTime = null;

    public GroupChangeStatusRequest withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 集团id
    * @return groupId
    **/
    @ApiModelProperty(value = "集团id")


    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public GroupChangeStatusRequest withOperateReason(String operateReason) {
        this.operateReason = operateReason;
        return this;
    }

    /**
    * 注销/启用原因
    * @return operateReason
    **/
    @ApiModelProperty(value = "注销/启用原因")


    public String getOperateReason() {
        return operateReason;
    }

    public void setOperateReason(String operateReason) {
        this.operateReason = operateReason;
    }

    public GroupChangeStatusRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public GroupChangeStatusRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 启用状态
    * @return status
    **/
    @ApiModelProperty(value = "启用状态")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public GroupChangeStatusRequest withUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
    * 更新时间戳
    * @return updateTime
    **/
    @ApiModelProperty(value = "更新时间戳")


    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GroupChangeStatusRequest groupChangeStatusRequest = (GroupChangeStatusRequest) o;
        return Objects.equals(this.groupId, groupChangeStatusRequest.groupId) &&
            Objects.equals(this.operateReason, groupChangeStatusRequest.operateReason) &&
            Objects.equals(this.rid, groupChangeStatusRequest.rid) &&
            Objects.equals(this.status, groupChangeStatusRequest.status) &&
            Objects.equals(this.updateTime, groupChangeStatusRequest.updateTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(groupId, operateReason, rid, status, updateTime);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GroupChangeStatusRequest }.
     */
    public static GroupChangeStatusRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GroupChangeStatusRequest.class);
    }
}

