package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class InUserAddRequest   {
    @JsonProperty("account")
    private String account = null;

    @JsonProperty("department")
    private String department = null;

    @JsonProperty("name")
    private String name = null;

    @JsonProperty("rid")
    private String rid = null;

    public InUserAddRequest withAccount(String account) {
        this.account = account;
        return this;
    }

    /**
    * 账号
    * @return account
    **/
    @ApiModelProperty(value = "账号")


    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public InUserAddRequest withDepartment(String department) {
        this.department = department;
        return this;
    }

    /**
    * 部门
    * @return department
    **/
    @ApiModelProperty(value = "部门")


    public String getDepartment() {
        return department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public InUserAddRequest withName(String name) {
        this.name = name;
        return this;
    }

    /**
    * 姓名
    * @return name
    **/
    @ApiModelProperty(value = "姓名")


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InUserAddRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InUserAddRequest inUserAddRequest = (InUserAddRequest) o;
        return Objects.equals(this.account, inUserAddRequest.account) &&
            Objects.equals(this.department, inUserAddRequest.department) &&
            Objects.equals(this.name, inUserAddRequest.name) &&
            Objects.equals(this.rid, inUserAddRequest.rid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(account, department, name, rid);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link InUserAddRequest }.
     */
    public static InUserAddRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, InUserAddRequest.class);
    }
}

