package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class InUserChangeStatusRequest   {
    @JsonProperty("inUserId")
    private Long inUserId = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("status")
    private Integer status = null;

    public InUserChangeStatusRequest withInUserId(Long inUserId) {
        this.inUserId = inUserId;
        return this;
    }

    /**
    * 用户Id
    * @return inUserId
    **/
    @ApiModelProperty(value = "用户Id")


    public Long getInUserId() {
        return inUserId;
    }

    public void setInUserId(Long inUserId) {
        this.inUserId = inUserId;
    }

    public InUserChangeStatusRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public InUserChangeStatusRequest withStatus(Integer status) {
        this.status = status;
        return this;
    }

    /**
    * 状态 1 有效，0无效 默认1
    * @return status
    **/
    @ApiModelProperty(value = "状态 1 有效，0无效 默认1")


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InUserChangeStatusRequest inUserChangeStatusRequest = (InUserChangeStatusRequest) o;
        return Objects.equals(this.inUserId, inUserChangeStatusRequest.inUserId) &&
            Objects.equals(this.rid, inUserChangeStatusRequest.rid) &&
            Objects.equals(this.status, inUserChangeStatusRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(inUserId, rid, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link InUserChangeStatusRequest }.
     */
    public static InUserChangeStatusRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, InUserChangeStatusRequest.class);
    }
}

