package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * OpenApiUserModel
 */
@ApiModel(description = "OpenApiUserModel")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class OpenApiUserModifyRequest   {
    @JsonProperty("openapiUserObject")
    private String openapiUserObject = null;

    @JsonProperty("openapiUserType")
    private String openapiUserType = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("status")
    private String status = null;

    @JsonProperty("userEmailAddr")
    private String userEmailAddr = null;

    @JsonProperty("userId")
    private String userId = null;

    public OpenApiUserModifyRequest withOpenapiUserObject(String openapiUserObject) {
        this.openapiUserObject = openapiUserObject;
        return this;
    }

    /**
    * 对象名称
    * @return openapiUserObject
    **/
    @ApiModelProperty(value = "对象名称")


    public String getOpenapiUserObject() {
        return openapiUserObject;
    }

    public void setOpenapiUserObject(String openapiUserObject) {
        this.openapiUserObject = openapiUserObject;
    }

    public OpenApiUserModifyRequest withOpenapiUserType(String openapiUserType) {
        this.openapiUserType = openapiUserType;
        return this;
    }

    /**
    * 对象类型 0伙伴;1客户;代理商
    * @return openapiUserType
    **/
    @ApiModelProperty(value = "对象类型 0伙伴;1客户;代理商")


    public String getOpenapiUserType() {
        return openapiUserType;
    }

    public void setOpenapiUserType(String openapiUserType) {
        this.openapiUserType = openapiUserType;
    }

    public OpenApiUserModifyRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * rid
    * @return rid
    **/
    @ApiModelProperty(value = "rid")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public OpenApiUserModifyRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 状态 1：启用  0：未启用 2:停用
    * @return status
    **/
    @ApiModelProperty(value = "状态 1：启用  0：未启用 2:停用")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public OpenApiUserModifyRequest withUserEmailAddr(String userEmailAddr) {
        this.userEmailAddr = userEmailAddr;
        return this;
    }

    /**
    * 邮箱地址
    * @return userEmailAddr
    **/
    @ApiModelProperty(value = "邮箱地址")


    public String getUserEmailAddr() {
        return userEmailAddr;
    }

    public void setUserEmailAddr(String userEmailAddr) {
        this.userEmailAddr = userEmailAddr;
    }

    public OpenApiUserModifyRequest withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    /**
    * 主键ID
    * @return userId
    **/
    @ApiModelProperty(value = "主键ID")


    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OpenApiUserModifyRequest openApiUserModifyRequest = (OpenApiUserModifyRequest) o;
        return Objects.equals(this.openapiUserObject, openApiUserModifyRequest.openapiUserObject) &&
            Objects.equals(this.openapiUserType, openApiUserModifyRequest.openapiUserType) &&
            Objects.equals(this.rid, openApiUserModifyRequest.rid) &&
            Objects.equals(this.status, openApiUserModifyRequest.status) &&
            Objects.equals(this.userEmailAddr, openApiUserModifyRequest.userEmailAddr) &&
            Objects.equals(this.userId, openApiUserModifyRequest.userId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(openapiUserObject, openapiUserType, rid, status, userEmailAddr, userId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link OpenApiUserModifyRequest }.
     */
    public static OpenApiUserModifyRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, OpenApiUserModifyRequest.class);
    }
}

