package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 查询详情入参
 */
@ApiModel(description = "查询详情入参")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class QueryDetailRequest   {
    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("terminalId")
    private String terminalId = null;

    public QueryDetailRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public QueryDetailRequest withTerminalId(String terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    /**
    * 终端id
    * @return terminalId
    **/
    @ApiModelProperty(value = "终端id")


    public String getTerminalId() {
        return terminalId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QueryDetailRequest queryDetailRequest = (QueryDetailRequest) o;
        return Objects.equals(this.rid, queryDetailRequest.rid) &&
            Objects.equals(this.terminalId, queryDetailRequest.terminalId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(rid, terminalId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link QueryDetailRequest }.
     */
    public static QueryDetailRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, QueryDetailRequest.class);
    }
}

