package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 税控底账服务器入参
 */
@ApiModel(description = "税控底账服务器入参")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class QueryDeviceListRequest   {
    @JsonProperty("companyName")
    private String companyName = null;

    @JsonProperty("originAccountTerminalId")
    private String originAccountTerminalId = null;

    @JsonProperty("page")
    private String page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private String row = null;

    @JsonProperty("status")
    private String status = null;

    @JsonProperty("taxDeviceType")
    private String taxDeviceType = null;

    @JsonProperty("taxNo")
    private String taxNo = null;

    public QueryDeviceListRequest withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
    * 公司名称
    * @return companyName
    **/
    @ApiModelProperty(value = "公司名称")


    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public QueryDeviceListRequest withOriginAccountTerminalId(String originAccountTerminalId) {
        this.originAccountTerminalId = originAccountTerminalId;
        return this;
    }

    /**
    * 底账服务器终端id
    * @return originAccountTerminalId
    **/
    @ApiModelProperty(value = "底账服务器终端id")


    public String getOriginAccountTerminalId() {
        return originAccountTerminalId;
    }

    public void setOriginAccountTerminalId(String originAccountTerminalId) {
        this.originAccountTerminalId = originAccountTerminalId;
    }

    public QueryDeviceListRequest withPage(String page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public QueryDeviceListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public QueryDeviceListRequest withRow(String row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public QueryDeviceListRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 税控钥匙状态
    * @return status
    **/
    @ApiModelProperty(value = "税控钥匙状态")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public QueryDeviceListRequest withTaxDeviceType(String taxDeviceType) {
        this.taxDeviceType = taxDeviceType;
        return this;
    }

    /**
    * 2 百望服务器  4 航信服务器(根据所选择的底账服务器来选择对应的设备服务器类型)
    * @return taxDeviceType
    **/
    @ApiModelProperty(value = "2 百望服务器  4 航信服务器(根据所选择的底账服务器来选择对应的设备服务器类型)")


    public String getTaxDeviceType() {
        return taxDeviceType;
    }

    public void setTaxDeviceType(String taxDeviceType) {
        this.taxDeviceType = taxDeviceType;
    }

    public QueryDeviceListRequest withTaxNo(String taxNo) {
        this.taxNo = taxNo;
        return this;
    }

    /**
    * 公司税号
    * @return taxNo
    **/
    @ApiModelProperty(value = "公司税号")


    public String getTaxNo() {
        return taxNo;
    }

    public void setTaxNo(String taxNo) {
        this.taxNo = taxNo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        QueryDeviceListRequest queryDeviceListRequest = (QueryDeviceListRequest) o;
        return Objects.equals(this.companyName, queryDeviceListRequest.companyName) &&
            Objects.equals(this.originAccountTerminalId, queryDeviceListRequest.originAccountTerminalId) &&
            Objects.equals(this.page, queryDeviceListRequest.page) &&
            Objects.equals(this.rid, queryDeviceListRequest.rid) &&
            Objects.equals(this.row, queryDeviceListRequest.row) &&
            Objects.equals(this.status, queryDeviceListRequest.status) &&
            Objects.equals(this.taxDeviceType, queryDeviceListRequest.taxDeviceType) &&
            Objects.equals(this.taxNo, queryDeviceListRequest.taxNo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyName, originAccountTerminalId, page, rid, row, status, taxDeviceType, taxNo);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link QueryDeviceListRequest }.
     */
    public static QueryDeviceListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, QueryDeviceListRequest.class);
    }
}

