package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 登陆请求对象
 */
@ApiModel(description = "登陆请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class SecurityLoginRequest   {
    @JsonProperty("password")
    private String password = null;

    @JsonProperty("username")
    private String username = null;

    public SecurityLoginRequest withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
    * 密码
    * @return password
    **/
    @ApiModelProperty(value = "密码")


    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public SecurityLoginRequest withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
    * 用户名
    * @return username
    **/
    @ApiModelProperty(value = "用户名")


    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecurityLoginRequest securityLoginRequest = (SecurityLoginRequest) o;
        return Objects.equals(this.password, securityLoginRequest.password) &&
            Objects.equals(this.username, securityLoginRequest.username);
    }

    @Override
    public int hashCode() {
        return Objects.hash(password, username);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link SecurityLoginRequest }.
     */
    public static SecurityLoginRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, SecurityLoginRequest.class);
    }
}

