package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.yiwan.seiya.phoenix.bss.app.model.ResourcesetModel;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class ServicePackageModelDetail   {
    @JsonProperty("createTime")
    private String createTime = null;

    @JsonProperty("createUserId")
    private String createUserId = null;

    @JsonProperty("createUserName")
    private String createUserName = null;

    @JsonProperty("servicePackageDesc")
    private String servicePackageDesc = null;

    @JsonProperty("servicePackageId")
    private String servicePackageId = null;

    @JsonProperty("servicePackageName")
    private String servicePackageName = null;

    @JsonProperty("serviceResourcesetList")
    @Valid
    private List<ResourcesetModel> serviceResourcesetList = null;

    @JsonProperty("status")
    private String status = null;

    @JsonProperty("statusTime")
    private String statusTime = null;

    @JsonProperty("updateTime")
    private String updateTime = null;

    @JsonProperty("updateUserId")
    private String updateUserId = null;

    @JsonProperty("updateUserName")
    private String updateUserName = null;

    public ServicePackageModelDetail withCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    /**
    * 创建时间
    * @return createTime
    **/
    @ApiModelProperty(value = "创建时间")


    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public ServicePackageModelDetail withCreateUserId(String createUserId) {
        this.createUserId = createUserId;
        return this;
    }

    /**
    * 创建人ID
    * @return createUserId
    **/
    @ApiModelProperty(value = "创建人ID")


    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public ServicePackageModelDetail withCreateUserName(String createUserName) {
        this.createUserName = createUserName;
        return this;
    }

    /**
    * 创建人名称
    * @return createUserName
    **/
    @ApiModelProperty(value = "创建人名称")


    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public ServicePackageModelDetail withServicePackageDesc(String servicePackageDesc) {
        this.servicePackageDesc = servicePackageDesc;
        return this;
    }

    /**
    * 服务包描述
    * @return servicePackageDesc
    **/
    @ApiModelProperty(value = "服务包描述")


    public String getServicePackageDesc() {
        return servicePackageDesc;
    }

    public void setServicePackageDesc(String servicePackageDesc) {
        this.servicePackageDesc = servicePackageDesc;
    }

    public ServicePackageModelDetail withServicePackageId(String servicePackageId) {
        this.servicePackageId = servicePackageId;
        return this;
    }

    /**
    * 服务包主键
    * @return servicePackageId
    **/
    @ApiModelProperty(value = "服务包主键")


    public String getServicePackageId() {
        return servicePackageId;
    }

    public void setServicePackageId(String servicePackageId) {
        this.servicePackageId = servicePackageId;
    }

    public ServicePackageModelDetail withServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
        return this;
    }

    /**
    * 服务包名称
    * @return servicePackageName
    **/
    @ApiModelProperty(value = "服务包名称")


    public String getServicePackageName() {
        return servicePackageName;
    }

    public void setServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
    }

    public ServicePackageModelDetail withServiceResourcesetList(List<ResourcesetModel> serviceResourcesetList) {
        this.serviceResourcesetList = serviceResourcesetList;
        return this;
    }

    public ServicePackageModelDetail withServiceResourcesetListAdd(ResourcesetModel serviceResourcesetList) {
        if (this.serviceResourcesetList == null) {
            this.serviceResourcesetList = new ArrayList<ResourcesetModel>();
        }
        this.serviceResourcesetList.add(serviceResourcesetList);
        return this;
    }

    /**
    * 服务包功能集关联
    * @return serviceResourcesetList
    **/
    @ApiModelProperty(value = "服务包功能集关联")

  @Valid

    public List<ResourcesetModel> getServiceResourcesetList() {
        return serviceResourcesetList;
    }

    public void setServiceResourcesetList(List<ResourcesetModel> serviceResourcesetList) {
        this.serviceResourcesetList = serviceResourcesetList;
    }

    public ServicePackageModelDetail withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 状态
    * @return status
    **/
    @ApiModelProperty(value = "状态")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ServicePackageModelDetail withStatusTime(String statusTime) {
        this.statusTime = statusTime;
        return this;
    }

    /**
    * 状态变更时间
    * @return statusTime
    **/
    @ApiModelProperty(value = "状态变更时间")


    public String getStatusTime() {
        return statusTime;
    }

    public void setStatusTime(String statusTime) {
        this.statusTime = statusTime;
    }

    public ServicePackageModelDetail withUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    /**
    * 更新时间
    * @return updateTime
    **/
    @ApiModelProperty(value = "更新时间")


    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public ServicePackageModelDetail withUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
        return this;
    }

    /**
    * 修改人ID
    * @return updateUserId
    **/
    @ApiModelProperty(value = "修改人ID")


    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
    }

    public ServicePackageModelDetail withUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
        return this;
    }

    /**
    * 修改人名称
    * @return updateUserName
    **/
    @ApiModelProperty(value = "修改人名称")


    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ServicePackageModelDetail servicePackageModelDetail = (ServicePackageModelDetail) o;
        return Objects.equals(this.createTime, servicePackageModelDetail.createTime) &&
            Objects.equals(this.createUserId, servicePackageModelDetail.createUserId) &&
            Objects.equals(this.createUserName, servicePackageModelDetail.createUserName) &&
            Objects.equals(this.servicePackageDesc, servicePackageModelDetail.servicePackageDesc) &&
            Objects.equals(this.servicePackageId, servicePackageModelDetail.servicePackageId) &&
            Objects.equals(this.servicePackageName, servicePackageModelDetail.servicePackageName) &&
            Objects.equals(this.serviceResourcesetList, servicePackageModelDetail.serviceResourcesetList) &&
            Objects.equals(this.status, servicePackageModelDetail.status) &&
            Objects.equals(this.statusTime, servicePackageModelDetail.statusTime) &&
            Objects.equals(this.updateTime, servicePackageModelDetail.updateTime) &&
            Objects.equals(this.updateUserId, servicePackageModelDetail.updateUserId) &&
            Objects.equals(this.updateUserName, servicePackageModelDetail.updateUserName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(createTime, createUserId, createUserName, servicePackageDesc, servicePackageId, servicePackageName, serviceResourcesetList, status, statusTime, updateTime, updateUserId, updateUserName);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link ServicePackageModelDetail }.
     */
    public static ServicePackageModelDetail fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, ServicePackageModelDetail.class);
    }
}

