package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class ServicePackageModifyRequest   {
    @JsonProperty("resourcesetIds")
    @Valid
    private List<String> resourcesetIds = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("servicePackageDesc")
    private String servicePackageDesc = null;

    @JsonProperty("servicePackageId")
    private String servicePackageId = null;

    @JsonProperty("servicePackageLogo")
    private String servicePackageLogo = null;

    @JsonProperty("servicePackageName")
    private String servicePackageName = null;

    @JsonProperty("status")
    private String status = null;

    public ServicePackageModifyRequest withResourcesetIds(List<String> resourcesetIds) {
        this.resourcesetIds = resourcesetIds;
        return this;
    }

    public ServicePackageModifyRequest withResourcesetIdsAdd(String resourcesetIds) {
        if (this.resourcesetIds == null) {
            this.resourcesetIds = new ArrayList<String>();
        }
        this.resourcesetIds.add(resourcesetIds);
        return this;
    }

    /**
    * 功能集主键列表
    * @return resourcesetIds
    **/
    @ApiModelProperty(value = "功能集主键列表")


    public List<String> getResourcesetIds() {
        return resourcesetIds;
    }

    public void setResourcesetIds(List<String> resourcesetIds) {
        this.resourcesetIds = resourcesetIds;
    }

    public ServicePackageModifyRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * rid
    * @return rid
    **/
    @ApiModelProperty(value = "rid")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public ServicePackageModifyRequest withServicePackageDesc(String servicePackageDesc) {
        this.servicePackageDesc = servicePackageDesc;
        return this;
    }

    /**
    * 集团Desc
    * @return servicePackageDesc
    **/
    @ApiModelProperty(value = "集团Desc")


    public String getServicePackageDesc() {
        return servicePackageDesc;
    }

    public void setServicePackageDesc(String servicePackageDesc) {
        this.servicePackageDesc = servicePackageDesc;
    }

    public ServicePackageModifyRequest withServicePackageId(String servicePackageId) {
        this.servicePackageId = servicePackageId;
        return this;
    }

    /**
    * 服务包ID
    * @return servicePackageId
    **/
    @ApiModelProperty(value = "服务包ID")


    public String getServicePackageId() {
        return servicePackageId;
    }

    public void setServicePackageId(String servicePackageId) {
        this.servicePackageId = servicePackageId;
    }

    public ServicePackageModifyRequest withServicePackageLogo(String servicePackageLogo) {
        this.servicePackageLogo = servicePackageLogo;
        return this;
    }

    /**
    * 集团Logo
    * @return servicePackageLogo
    **/
    @ApiModelProperty(value = "集团Logo")


    public String getServicePackageLogo() {
        return servicePackageLogo;
    }

    public void setServicePackageLogo(String servicePackageLogo) {
        this.servicePackageLogo = servicePackageLogo;
    }

    public ServicePackageModifyRequest withServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
        return this;
    }

    /**
    * 服务包名称
    * @return servicePackageName
    **/
    @ApiModelProperty(value = "服务包名称")


    public String getServicePackageName() {
        return servicePackageName;
    }

    public void setServicePackageName(String servicePackageName) {
        this.servicePackageName = servicePackageName;
    }

    public ServicePackageModifyRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 状态
    * @return status
    **/
    @ApiModelProperty(value = "状态")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ServicePackageModifyRequest servicePackageModifyRequest = (ServicePackageModifyRequest) o;
        return Objects.equals(this.resourcesetIds, servicePackageModifyRequest.resourcesetIds) &&
            Objects.equals(this.rid, servicePackageModifyRequest.rid) &&
            Objects.equals(this.servicePackageDesc, servicePackageModifyRequest.servicePackageDesc) &&
            Objects.equals(this.servicePackageId, servicePackageModifyRequest.servicePackageId) &&
            Objects.equals(this.servicePackageLogo, servicePackageModifyRequest.servicePackageLogo) &&
            Objects.equals(this.servicePackageName, servicePackageModifyRequest.servicePackageName) &&
            Objects.equals(this.status, servicePackageModifyRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resourcesetIds, rid, servicePackageDesc, servicePackageId, servicePackageLogo, servicePackageName, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link ServicePackageModifyRequest }.
     */
    public static ServicePackageModifyRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, ServicePackageModifyRequest.class);
    }
}

