package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * null
 */
@ApiModel(description = "null")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class SignatureModel   {
    @JsonProperty("accessId")
    private String accessId = null;

    @JsonProperty("expire")
    private String expire = null;

    @JsonProperty("fileBaseUrl")
    private String fileBaseUrl = null;

    @JsonProperty("fileDirectory")
    private String fileDirectory = null;

    @JsonProperty("host")
    private String host = null;

    @JsonProperty("policy")
    private String policy = null;

    @JsonProperty("signature")
    private String signature = null;

    public SignatureModel withAccessId(String accessId) {
        this.accessId = accessId;
        return this;
    }

    /**
    * 访问oss需要的id
    * @return accessId
    **/
    @ApiModelProperty(value = "访问oss需要的id")


    public String getAccessId() {
        return accessId;
    }

    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public SignatureModel withExpire(String expire) {
        this.expire = expire;
        return this;
    }

    /**
    * 签名过期时间
    * @return expire
    **/
    @ApiModelProperty(value = "签名过期时间")


    public String getExpire() {
        return expire;
    }

    public void setExpire(String expire) {
        this.expire = expire;
    }

    public SignatureModel withFileBaseUrl(String fileBaseUrl) {
        this.fileBaseUrl = fileBaseUrl;
        return this;
    }

    /**
    * 访问文件的域名
    * @return fileBaseUrl
    **/
    @ApiModelProperty(value = "访问文件的域名")


    public String getFileBaseUrl() {
        return fileBaseUrl;
    }

    public void setFileBaseUrl(String fileBaseUrl) {
        this.fileBaseUrl = fileBaseUrl;
    }

    public SignatureModel withFileDirectory(String fileDirectory) {
        this.fileDirectory = fileDirectory;
        return this;
    }

    /**
    * 设备id，查询时返回
    * @return fileDirectory
    **/
    @ApiModelProperty(value = "设备id，查询时返回")


    public String getFileDirectory() {
        return fileDirectory;
    }

    public void setFileDirectory(String fileDirectory) {
        this.fileDirectory = fileDirectory;
    }

    public SignatureModel withHost(String host) {
        this.host = host;
        return this;
    }

    /**
    * oss的host
    * @return host
    **/
    @ApiModelProperty(value = "oss的host")


    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public SignatureModel withPolicy(String policy) {
        this.policy = policy;
        return this;
    }

    /**
    * 访问oss需要的参数
    * @return policy
    **/
    @ApiModelProperty(value = "访问oss需要的参数")


    public String getPolicy() {
        return policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public SignatureModel withSignature(String signature) {
        this.signature = signature;
        return this;
    }

    /**
    * 访问oss需要的签名
    * @return signature
    **/
    @ApiModelProperty(value = "访问oss需要的签名")


    public String getSignature() {
        return signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SignatureModel signatureModel = (SignatureModel) o;
        return Objects.equals(this.accessId, signatureModel.accessId) &&
            Objects.equals(this.expire, signatureModel.expire) &&
            Objects.equals(this.fileBaseUrl, signatureModel.fileBaseUrl) &&
            Objects.equals(this.fileDirectory, signatureModel.fileDirectory) &&
            Objects.equals(this.host, signatureModel.host) &&
            Objects.equals(this.policy, signatureModel.policy) &&
            Objects.equals(this.signature, signatureModel.signature);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accessId, expire, fileBaseUrl, fileDirectory, host, policy, signature);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link SignatureModel }.
     */
    public static SignatureModel fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, SignatureModel.class);
    }
}

