package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class TenantAddRequest   {
    @JsonProperty("companyAddr")
    private String companyAddr = null;

    @JsonProperty("companyName")
    private String companyName = null;

    @JsonProperty("companyTel")
    private String companyTel = null;

    @JsonProperty("contactName")
    private String contactName = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("tenantEmail")
    private String tenantEmail = null;

    @JsonProperty("tenantPhone")
    private String tenantPhone = null;

    public TenantAddRequest withCompanyAddr(String companyAddr) {
        this.companyAddr = companyAddr;
        return this;
    }

    /**
    * 企业地址
    * @return companyAddr
    **/
    @ApiModelProperty(value = "企业地址")


    public String getCompanyAddr() {
        return companyAddr;
    }

    public void setCompanyAddr(String companyAddr) {
        this.companyAddr = companyAddr;
    }

    public TenantAddRequest withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
    * 企业名称
    * @return companyName
    **/
    @ApiModelProperty(value = "企业名称")


    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public TenantAddRequest withCompanyTel(String companyTel) {
        this.companyTel = companyTel;
        return this;
    }

    /**
    * 企业电话号码
    * @return companyTel
    **/
    @ApiModelProperty(value = "企业电话号码")


    public String getCompanyTel() {
        return companyTel;
    }

    public void setCompanyTel(String companyTel) {
        this.companyTel = companyTel;
    }

    public TenantAddRequest withContactName(String contactName) {
        this.contactName = contactName;
        return this;
    }

    /**
    * 联系人姓名
    * @return contactName
    **/
    @ApiModelProperty(value = "联系人姓名")


    public String getContactName() {
        return contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public TenantAddRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public TenantAddRequest withTenantEmail(String tenantEmail) {
        this.tenantEmail = tenantEmail;
        return this;
    }

    /**
    * 租户邮箱
    * @return tenantEmail
    **/
    @ApiModelProperty(value = "租户邮箱")


    public String getTenantEmail() {
        return tenantEmail;
    }

    public void setTenantEmail(String tenantEmail) {
        this.tenantEmail = tenantEmail;
    }

    public TenantAddRequest withTenantPhone(String tenantPhone) {
        this.tenantPhone = tenantPhone;
        return this;
    }

    /**
    * 租户手机号
    * @return tenantPhone
    **/
    @ApiModelProperty(value = "租户手机号")


    public String getTenantPhone() {
        return tenantPhone;
    }

    public void setTenantPhone(String tenantPhone) {
        this.tenantPhone = tenantPhone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TenantAddRequest tenantAddRequest = (TenantAddRequest) o;
        return Objects.equals(this.companyAddr, tenantAddRequest.companyAddr) &&
            Objects.equals(this.companyName, tenantAddRequest.companyName) &&
            Objects.equals(this.companyTel, tenantAddRequest.companyTel) &&
            Objects.equals(this.contactName, tenantAddRequest.contactName) &&
            Objects.equals(this.rid, tenantAddRequest.rid) &&
            Objects.equals(this.tenantEmail, tenantAddRequest.tenantEmail) &&
            Objects.equals(this.tenantPhone, tenantAddRequest.tenantPhone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyAddr, companyName, companyTel, contactName, rid, tenantEmail, tenantPhone);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link TenantAddRequest }.
     */
    public static TenantAddRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, TenantAddRequest.class);
    }
}

