package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class TenantChangeStatusRequest   {
    @JsonProperty("operateReason")
    private String operateReason = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("status")
    private String status = null;

    @JsonProperty("tenantId")
    private String tenantId = null;

    public TenantChangeStatusRequest withOperateReason(String operateReason) {
        this.operateReason = operateReason;
        return this;
    }

    /**
    * 修改原因
    * @return operateReason
    **/
    @ApiModelProperty(value = "修改原因")


    public String getOperateReason() {
        return operateReason;
    }

    public void setOperateReason(String operateReason) {
        this.operateReason = operateReason;
    }

    public TenantChangeStatusRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public TenantChangeStatusRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 状态：1：启用，0：注销
    * @return status
    **/
    @ApiModelProperty(value = "状态：1：启用，0：注销")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public TenantChangeStatusRequest withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
    * 租户主键id
    * @return tenantId
    **/
    @ApiModelProperty(value = "租户主键id")


    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TenantChangeStatusRequest tenantChangeStatusRequest = (TenantChangeStatusRequest) o;
        return Objects.equals(this.operateReason, tenantChangeStatusRequest.operateReason) &&
            Objects.equals(this.rid, tenantChangeStatusRequest.rid) &&
            Objects.equals(this.status, tenantChangeStatusRequest.status) &&
            Objects.equals(this.tenantId, tenantChangeStatusRequest.tenantId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(operateReason, rid, status, tenantId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link TenantChangeStatusRequest }.
     */
    public static TenantChangeStatusRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, TenantChangeStatusRequest.class);
    }
}

