package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 税控底账服务器入参
 */
@ApiModel(description = "税控底账服务器入参")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class TerminalAddRequest   {
    @JsonProperty("deployType")
    private String deployType = null;

    @JsonProperty("groupId")
    private String groupId = null;

    @JsonProperty("groupName")
    private String groupName = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("supportService")
    private String supportService = null;

    @JsonProperty("terminalMode")
    private String terminalMode = null;

    @JsonProperty("terminalNo")
    private String terminalNo = null;

    public TerminalAddRequest withDeployType(String deployType) {
        this.deployType = deployType;
        return this;
    }

    /**
    * 部署类型，1 票易通部署 2 非票易通部署
    * @return deployType
    **/
    @ApiModelProperty(value = "部署类型，1 票易通部署 2 非票易通部署")


    public String getDeployType() {
        return deployType;
    }

    public void setDeployType(String deployType) {
        this.deployType = deployType;
    }

    public TerminalAddRequest withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 集团id
    * @return groupId
    **/
    @ApiModelProperty(value = "集团id")


    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public TerminalAddRequest withGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    /**
    * 集团名称
    * @return groupName
    **/
    @ApiModelProperty(value = "集团名称")


    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public TerminalAddRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public TerminalAddRequest withSupportService(String supportService) {
        this.supportService = supportService;
        return this;
    }

    /**
    * 支持的服务（print:打印 make:开票,originAccount:底账,assistant：辅助）
    * @return supportService
    **/
    @ApiModelProperty(value = "支持的服务（print:打印 make:开票,originAccount:底账,assistant：辅助）")


    public String getSupportService() {
        return supportService;
    }

    public void setSupportService(String supportService) {
        this.supportService = supportService;
    }

    public TerminalAddRequest withTerminalMode(String terminalMode) {
        this.terminalMode = terminalMode;
        return this;
    }

    /**
    * 终端物理设备类型，2 百望服务器 4 航信服务器
    * @return terminalMode
    **/
    @ApiModelProperty(value = "终端物理设备类型，2 百望服务器 4 航信服务器")


    public String getTerminalMode() {
        return terminalMode;
    }

    public void setTerminalMode(String terminalMode) {
        this.terminalMode = terminalMode;
    }

    public TerminalAddRequest withTerminalNo(String terminalNo) {
        this.terminalNo = terminalNo;
        return this;
    }

    /**
    * 终端编号(设备编号)
    * @return terminalNo
    **/
    @ApiModelProperty(value = "终端编号(设备编号)")


    public String getTerminalNo() {
        return terminalNo;
    }

    public void setTerminalNo(String terminalNo) {
        this.terminalNo = terminalNo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TerminalAddRequest terminalAddRequest = (TerminalAddRequest) o;
        return Objects.equals(this.deployType, terminalAddRequest.deployType) &&
            Objects.equals(this.groupId, terminalAddRequest.groupId) &&
            Objects.equals(this.groupName, terminalAddRequest.groupName) &&
            Objects.equals(this.rid, terminalAddRequest.rid) &&
            Objects.equals(this.supportService, terminalAddRequest.supportService) &&
            Objects.equals(this.terminalMode, terminalAddRequest.terminalMode) &&
            Objects.equals(this.terminalNo, terminalAddRequest.terminalNo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deployType, groupId, groupName, rid, supportService, terminalMode, terminalNo);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link TerminalAddRequest }.
     */
    public static TerminalAddRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, TerminalAddRequest.class);
    }
}

