package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.yiwan.seiya.phoenix.bss.app.model.TerminalDeviceModel;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 税控底账服务器的税控钥匙入参
 */
@ApiModel(description = "税控底账服务器的税控钥匙入参")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class TerminalDeviceAddRequest   {
    @JsonProperty("deployType")
    private String deployType = null;

    @JsonProperty("deviceModels")
    @Valid
    private List<TerminalDeviceModel> deviceModels = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("terminalId")
    private String terminalId = null;

    @JsonProperty("terminalMode")
    private String terminalMode = null;

    public TerminalDeviceAddRequest withDeployType(String deployType) {
        this.deployType = deployType;
        return this;
    }

    /**
    * 部署类型，1 票易通部署 2 非票易通部署
    * @return deployType
    **/
    @ApiModelProperty(value = "部署类型，1 票易通部署 2 非票易通部署")


    public String getDeployType() {
        return deployType;
    }

    public void setDeployType(String deployType) {
        this.deployType = deployType;
    }

    public TerminalDeviceAddRequest withDeviceModels(List<TerminalDeviceModel> deviceModels) {
        this.deviceModels = deviceModels;
        return this;
    }

    public TerminalDeviceAddRequest withDeviceModelsAdd(TerminalDeviceModel deviceModels) {
        if (this.deviceModels == null) {
            this.deviceModels = new ArrayList<TerminalDeviceModel>();
        }
        this.deviceModels.add(deviceModels);
        return this;
    }

    /**
    * 设备信息集合  包含公司及对应设备详情
    * @return deviceModels
    **/
    @ApiModelProperty(value = "设备信息集合  包含公司及对应设备详情")

  @Valid

    public List<TerminalDeviceModel> getDeviceModels() {
        return deviceModels;
    }

    public void setDeviceModels(List<TerminalDeviceModel> deviceModels) {
        this.deviceModels = deviceModels;
    }

    public TerminalDeviceAddRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public TerminalDeviceAddRequest withTerminalId(String terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    /**
    * 底账服务器id
    * @return terminalId
    **/
    @ApiModelProperty(value = "底账服务器id")


    public String getTerminalId() {
        return terminalId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public TerminalDeviceAddRequest withTerminalMode(String terminalMode) {
        this.terminalMode = terminalMode;
        return this;
    }

    /**
    * 终端物理设备类型，2 百望服务器 4 航信服务器
    * @return terminalMode
    **/
    @ApiModelProperty(value = "终端物理设备类型，2 百望服务器 4 航信服务器")


    public String getTerminalMode() {
        return terminalMode;
    }

    public void setTerminalMode(String terminalMode) {
        this.terminalMode = terminalMode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TerminalDeviceAddRequest terminalDeviceAddRequest = (TerminalDeviceAddRequest) o;
        return Objects.equals(this.deployType, terminalDeviceAddRequest.deployType) &&
            Objects.equals(this.deviceModels, terminalDeviceAddRequest.deviceModels) &&
            Objects.equals(this.rid, terminalDeviceAddRequest.rid) &&
            Objects.equals(this.terminalId, terminalDeviceAddRequest.terminalId) &&
            Objects.equals(this.terminalMode, terminalDeviceAddRequest.terminalMode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deployType, deviceModels, rid, terminalId, terminalMode);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link TerminalDeviceAddRequest }.
     */
    public static TerminalDeviceAddRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, TerminalDeviceAddRequest.class);
    }
}

