package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * null
 */
@ApiModel(description = "null")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class TerminalDeviceModel   {
    @JsonProperty("companyId")
    private String companyId = null;

    @JsonProperty("companyName")
    private String companyName = null;

    @JsonProperty("deviceNo")
    private String deviceNo = null;

    @JsonProperty("groupId")
    private String groupId = null;

    @JsonProperty("groupName")
    private String groupName = null;

    @JsonProperty("id")
    private String id = null;

    @JsonProperty("nationalTaxPassword")
    private String nationalTaxPassword = null;

    @JsonProperty("organizationId")
    private String organizationId = null;

    @JsonProperty("organizationName")
    private String organizationName = null;

    @JsonProperty("photos")
    @Valid
    private List<String> photos = null;

    @JsonProperty("serverUrl")
    private String serverUrl = null;

    @JsonProperty("status")
    private String status = null;

    @JsonProperty("taxDeviceDigitalPassword")
    private String taxDeviceDigitalPassword = null;

    @JsonProperty("taxNum")
    private String taxNum = null;

    public TerminalDeviceModel withCompanyId(String companyId) {
        this.companyId = companyId;
        return this;
    }

    /**
    * 公司id
    * @return companyId
    **/
    @ApiModelProperty(value = "公司id")


    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public TerminalDeviceModel withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
    * 公司名称
    * @return companyName
    **/
    @ApiModelProperty(value = "公司名称")


    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public TerminalDeviceModel withDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
        return this;
    }

    /**
    * 设备编号
    * @return deviceNo
    **/
    @ApiModelProperty(value = "设备编号")


    public String getDeviceNo() {
        return deviceNo;
    }

    public void setDeviceNo(String deviceNo) {
        this.deviceNo = deviceNo;
    }

    public TerminalDeviceModel withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 租户id
    * @return groupId
    **/
    @ApiModelProperty(value = "租户id")


    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public TerminalDeviceModel withGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    /**
    * 租户名称
    * @return groupName
    **/
    @ApiModelProperty(value = "租户名称")


    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public TerminalDeviceModel withId(String id) {
        this.id = id;
        return this;
    }

    /**
    * 设备id
    * @return id
    **/
    @ApiModelProperty(value = "设备id")


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TerminalDeviceModel withNationalTaxPassword(String nationalTaxPassword) {
        this.nationalTaxPassword = nationalTaxPassword;
        return this;
    }

    /**
    * 国税自定义密码
    * @return nationalTaxPassword
    **/
    @ApiModelProperty(value = "国税自定义密码")


    public String getNationalTaxPassword() {
        return nationalTaxPassword;
    }

    public void setNationalTaxPassword(String nationalTaxPassword) {
        this.nationalTaxPassword = nationalTaxPassword;
    }

    public TerminalDeviceModel withOrganizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    /**
    * 组织id
    * @return organizationId
    **/
    @ApiModelProperty(value = "组织id")


    public String getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public TerminalDeviceModel withOrganizationName(String organizationName) {
        this.organizationName = organizationName;
        return this;
    }

    /**
    * 组织名称
    * @return organizationName
    **/
    @ApiModelProperty(value = "组织名称")


    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public TerminalDeviceModel withPhotos(List<String> photos) {
        this.photos = photos;
        return this;
    }

    public TerminalDeviceModel withPhotosAdd(String photos) {
        if (this.photos == null) {
            this.photos = new ArrayList<String>();
        }
        this.photos.add(photos);
        return this;
    }

    /**
    * 图片集合
    * @return photos
    **/
    @ApiModelProperty(value = "图片集合")


    public List<String> getPhotos() {
        return photos;
    }

    public void setPhotos(List<String> photos) {
        this.photos = photos;
    }

    public TerminalDeviceModel withServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    /**
    * 直连服务器版涉及到的URL信息 示例：TaxPBserver/kpservices/KpWebService
    * @return serverUrl
    **/
    @ApiModelProperty(value = "直连服务器版涉及到的URL信息 示例：TaxPBserver/kpservices/KpWebService")


    public String getServerUrl() {
        return serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public TerminalDeviceModel withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭 22：作废）
    * @return status
    **/
    @ApiModelProperty(value = "设备状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭 22：作废）")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public TerminalDeviceModel withTaxDeviceDigitalPassword(String taxDeviceDigitalPassword) {
        this.taxDeviceDigitalPassword = taxDeviceDigitalPassword;
        return this;
    }

    /**
    * 税控钥匙密码
    * @return taxDeviceDigitalPassword
    **/
    @ApiModelProperty(value = "税控钥匙密码")


    public String getTaxDeviceDigitalPassword() {
        return taxDeviceDigitalPassword;
    }

    public void setTaxDeviceDigitalPassword(String taxDeviceDigitalPassword) {
        this.taxDeviceDigitalPassword = taxDeviceDigitalPassword;
    }

    public TerminalDeviceModel withTaxNum(String taxNum) {
        this.taxNum = taxNum;
        return this;
    }

    /**
    * 企业纳税人识别号
    * @return taxNum
    **/
    @ApiModelProperty(value = "企业纳税人识别号")


    public String getTaxNum() {
        return taxNum;
    }

    public void setTaxNum(String taxNum) {
        this.taxNum = taxNum;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TerminalDeviceModel terminalDeviceModel = (TerminalDeviceModel) o;
        return Objects.equals(this.companyId, terminalDeviceModel.companyId) &&
            Objects.equals(this.companyName, terminalDeviceModel.companyName) &&
            Objects.equals(this.deviceNo, terminalDeviceModel.deviceNo) &&
            Objects.equals(this.groupId, terminalDeviceModel.groupId) &&
            Objects.equals(this.groupName, terminalDeviceModel.groupName) &&
            Objects.equals(this.id, terminalDeviceModel.id) &&
            Objects.equals(this.nationalTaxPassword, terminalDeviceModel.nationalTaxPassword) &&
            Objects.equals(this.organizationId, terminalDeviceModel.organizationId) &&
            Objects.equals(this.organizationName, terminalDeviceModel.organizationName) &&
            Objects.equals(this.photos, terminalDeviceModel.photos) &&
            Objects.equals(this.serverUrl, terminalDeviceModel.serverUrl) &&
            Objects.equals(this.status, terminalDeviceModel.status) &&
            Objects.equals(this.taxDeviceDigitalPassword, terminalDeviceModel.taxDeviceDigitalPassword) &&
            Objects.equals(this.taxNum, terminalDeviceModel.taxNum);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyId, companyName, deviceNo, groupId, groupName, id, nationalTaxPassword, organizationId, organizationName, photos, serverUrl, status, taxDeviceDigitalPassword, taxNum);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link TerminalDeviceModel }.
     */
    public static TerminalDeviceModel fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, TerminalDeviceModel.class);
    }
}

