package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 税控底账服务器入参
 */
@ApiModel(description = "税控底账服务器入参")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class TerminalQueryRequest   {
    @JsonProperty("companyName")
    private String companyName = null;

    @JsonProperty("groupName")
    private String groupName = null;

    @JsonProperty("page")
    private String page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private String row = null;

    @JsonProperty("status")
    private String status = null;

    @JsonProperty("terminalNo")
    private String terminalNo = null;

    public TerminalQueryRequest withCompanyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    /**
    * 公司名称
    * @return companyName
    **/
    @ApiModelProperty(value = "公司名称")


    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public TerminalQueryRequest withGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    /**
    * 公司名称
    * @return groupName
    **/
    @ApiModelProperty(value = "公司名称")


    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public TerminalQueryRequest withPage(String page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public String getPage() {
        return page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public TerminalQueryRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public TerminalQueryRequest withRow(String row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public String getRow() {
        return row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    public TerminalQueryRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭 ）
    * @return status
    **/
    @ApiModelProperty(value = "状态（0：待审核 1:审核通过 2：审核失败 11：启用 12：未启用 21：关闭 ）")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public TerminalQueryRequest withTerminalNo(String terminalNo) {
        this.terminalNo = terminalNo;
        return this;
    }

    /**
    * 服务器编号(终端编号)
    * @return terminalNo
    **/
    @ApiModelProperty(value = "服务器编号(终端编号)")


    public String getTerminalNo() {
        return terminalNo;
    }

    public void setTerminalNo(String terminalNo) {
        this.terminalNo = terminalNo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TerminalQueryRequest terminalQueryRequest = (TerminalQueryRequest) o;
        return Objects.equals(this.companyName, terminalQueryRequest.companyName) &&
            Objects.equals(this.groupName, terminalQueryRequest.groupName) &&
            Objects.equals(this.page, terminalQueryRequest.page) &&
            Objects.equals(this.rid, terminalQueryRequest.rid) &&
            Objects.equals(this.row, terminalQueryRequest.row) &&
            Objects.equals(this.status, terminalQueryRequest.status) &&
            Objects.equals(this.terminalNo, terminalQueryRequest.terminalNo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyName, groupName, page, rid, row, status, terminalNo);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link TerminalQueryRequest }.
     */
    public static TerminalQueryRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, TerminalQueryRequest.class);
    }
}

