package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 税控底账服务器入参
 */
@ApiModel(description = "税控底账服务器入参")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class TerminalUpdateStatusRequest   {
    @JsonProperty("id")
    private String id = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("status")
    private String status = null;

    public TerminalUpdateStatusRequest withId(String id) {
        this.id = id;
        return this;
    }

    /**
    * 服务器终端主键id
    * @return id
    **/
    @ApiModelProperty(value = "服务器终端主键id")


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public TerminalUpdateStatusRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public TerminalUpdateStatusRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 状态（11：启用 21：关闭 22：作废(删除即作废)）
    * @return status
    **/
    @ApiModelProperty(value = "状态（11：启用 21：关闭 22：作废(删除即作废)）")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TerminalUpdateStatusRequest terminalUpdateStatusRequest = (TerminalUpdateStatusRequest) o;
        return Objects.equals(this.id, terminalUpdateStatusRequest.id) &&
            Objects.equals(this.rid, terminalUpdateStatusRequest.rid) &&
            Objects.equals(this.status, terminalUpdateStatusRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, rid, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link TerminalUpdateStatusRequest }.
     */
    public static TerminalUpdateStatusRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, TerminalUpdateStatusRequest.class);
    }
}

