package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 传统认证管理
 */
@ApiModel(description = "传统认证管理")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class TraditionAuthenFlagRequest   {
    @JsonProperty("companyIds")
    private String companyIds = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("traditionAuthenFlag")
    private String traditionAuthenFlag = null;

    public TraditionAuthenFlagRequest withCompanyIds(String companyIds) {
        this.companyIds = companyIds;
        return this;
    }

    /**
    * 公司ids，多个公司id用逗号隔开
    * @return companyIds
    **/
    @ApiModelProperty(value = "公司ids，多个公司id用逗号隔开")


    public String getCompanyIds() {
        return companyIds;
    }

    public void setCompanyIds(String companyIds) {
        this.companyIds = companyIds;
    }

    public TraditionAuthenFlagRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public TraditionAuthenFlagRequest withTraditionAuthenFlag(String traditionAuthenFlag) {
        this.traditionAuthenFlag = traditionAuthenFlag;
        return this;
    }

    /**
    * 传统认证管理状态(1:开启；0:关闭)
    * @return traditionAuthenFlag
    **/
    @ApiModelProperty(value = "传统认证管理状态(1:开启；0:关闭)")


    public String getTraditionAuthenFlag() {
        return traditionAuthenFlag;
    }

    public void setTraditionAuthenFlag(String traditionAuthenFlag) {
        this.traditionAuthenFlag = traditionAuthenFlag;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TraditionAuthenFlagRequest traditionAuthenFlagRequest = (TraditionAuthenFlagRequest) o;
        return Objects.equals(this.companyIds, traditionAuthenFlagRequest.companyIds) &&
            Objects.equals(this.rid, traditionAuthenFlagRequest.rid) &&
            Objects.equals(this.traditionAuthenFlag, traditionAuthenFlagRequest.traditionAuthenFlag);
    }

    @Override
    public int hashCode() {
        return Objects.hash(companyIds, rid, traditionAuthenFlag);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link TraditionAuthenFlagRequest }.
     */
    public static TraditionAuthenFlagRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, TraditionAuthenFlagRequest.class);
    }
}

