package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 响应对象
 */
@ApiModel(description = "响应对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class TraditionAuthenFlagResponse   {
    @JsonProperty("code")
    private Integer code = null;

    @JsonProperty("message")
    private String message = null;

    @JsonProperty("result")
    private Object result = null;

    public TraditionAuthenFlagResponse withCode(Integer code) {
        this.code = code;
        return this;
    }

    /**
    * return code
    * @return code
    **/
    @ApiModelProperty(value = "return code")


    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public TraditionAuthenFlagResponse withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
    * return message
    * @return message
    **/
    @ApiModelProperty(value = "return message")


    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public TraditionAuthenFlagResponse withResult(Object result) {
        this.result = result;
        return this;
    }

    /**
    * 传统认证管理
    * @return result
    **/
    @ApiModelProperty(value = "传统认证管理")


    public Object getResult() {
        return result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TraditionAuthenFlagResponse traditionAuthenFlagResponse = (TraditionAuthenFlagResponse) o;
        return Objects.equals(this.code, traditionAuthenFlagResponse.code) &&
            Objects.equals(this.message, traditionAuthenFlagResponse.message) &&
            Objects.equals(this.result, traditionAuthenFlagResponse.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, message, result);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link TraditionAuthenFlagResponse }.
     */
    public static TraditionAuthenFlagResponse fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, TraditionAuthenFlagResponse.class);
    }
}

