package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 税控底账服务器税控钥匙入参
 */
@ApiModel(description = "税控底账服务器税控钥匙入参")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class UpdateTermDeviceRequest   {
    @JsonProperty("deployType")
    private String deployType = null;

    @JsonProperty("id")
    private String id = null;

    @JsonProperty("nationalTaxPassword")
    private String nationalTaxPassword = null;

    @JsonProperty("photos")
    @Valid
    private List<String> photos = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("taxDeviceDigitalPassword")
    private String taxDeviceDigitalPassword = null;

    @JsonProperty("terminalId")
    private String terminalId = null;

    @JsonProperty("terminalMode")
    private String terminalMode = null;

    public UpdateTermDeviceRequest withDeployType(String deployType) {
        this.deployType = deployType;
        return this;
    }

    /**
    * 部署类型，1 票易通部署 2 非票易通部署
    * @return deployType
    **/
    @ApiModelProperty(value = "部署类型，1 票易通部署 2 非票易通部署")


    public String getDeployType() {
        return deployType;
    }

    public void setDeployType(String deployType) {
        this.deployType = deployType;
    }

    public UpdateTermDeviceRequest withId(String id) {
        this.id = id;
        return this;
    }

    /**
    * 税控钥匙id
    * @return id
    **/
    @ApiModelProperty(value = "税控钥匙id")


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UpdateTermDeviceRequest withNationalTaxPassword(String nationalTaxPassword) {
        this.nationalTaxPassword = nationalTaxPassword;
        return this;
    }

    /**
    * 国税自定义密码
    * @return nationalTaxPassword
    **/
    @ApiModelProperty(value = "国税自定义密码")


    public String getNationalTaxPassword() {
        return nationalTaxPassword;
    }

    public void setNationalTaxPassword(String nationalTaxPassword) {
        this.nationalTaxPassword = nationalTaxPassword;
    }

    public UpdateTermDeviceRequest withPhotos(List<String> photos) {
        this.photos = photos;
        return this;
    }

    public UpdateTermDeviceRequest withPhotosAdd(String photos) {
        if (this.photos == null) {
            this.photos = new ArrayList<String>();
        }
        this.photos.add(photos);
        return this;
    }

    /**
    * 图片集合
    * @return photos
    **/
    @ApiModelProperty(value = "图片集合")


    public List<String> getPhotos() {
        return photos;
    }

    public void setPhotos(List<String> photos) {
        this.photos = photos;
    }

    public UpdateTermDeviceRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public UpdateTermDeviceRequest withTaxDeviceDigitalPassword(String taxDeviceDigitalPassword) {
        this.taxDeviceDigitalPassword = taxDeviceDigitalPassword;
        return this;
    }

    /**
    * 税控钥匙密码
    * @return taxDeviceDigitalPassword
    **/
    @ApiModelProperty(value = "税控钥匙密码")


    public String getTaxDeviceDigitalPassword() {
        return taxDeviceDigitalPassword;
    }

    public void setTaxDeviceDigitalPassword(String taxDeviceDigitalPassword) {
        this.taxDeviceDigitalPassword = taxDeviceDigitalPassword;
    }

    public UpdateTermDeviceRequest withTerminalId(String terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    /**
    * 终端id
    * @return terminalId
    **/
    @ApiModelProperty(value = "终端id")


    public String getTerminalId() {
        return terminalId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public UpdateTermDeviceRequest withTerminalMode(String terminalMode) {
        this.terminalMode = terminalMode;
        return this;
    }

    /**
    * 终端物理设备类型，2 百望服务器 4 航信服务器
    * @return terminalMode
    **/
    @ApiModelProperty(value = "终端物理设备类型，2 百望服务器 4 航信服务器")


    public String getTerminalMode() {
        return terminalMode;
    }

    public void setTerminalMode(String terminalMode) {
        this.terminalMode = terminalMode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateTermDeviceRequest updateTermDeviceRequest = (UpdateTermDeviceRequest) o;
        return Objects.equals(this.deployType, updateTermDeviceRequest.deployType) &&
            Objects.equals(this.id, updateTermDeviceRequest.id) &&
            Objects.equals(this.nationalTaxPassword, updateTermDeviceRequest.nationalTaxPassword) &&
            Objects.equals(this.photos, updateTermDeviceRequest.photos) &&
            Objects.equals(this.rid, updateTermDeviceRequest.rid) &&
            Objects.equals(this.taxDeviceDigitalPassword, updateTermDeviceRequest.taxDeviceDigitalPassword) &&
            Objects.equals(this.terminalId, updateTermDeviceRequest.terminalId) &&
            Objects.equals(this.terminalMode, updateTermDeviceRequest.terminalMode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deployType, id, nationalTaxPassword, photos, rid, taxDeviceDigitalPassword, terminalId, terminalMode);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link UpdateTermDeviceRequest }.
     */
    public static UpdateTermDeviceRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, UpdateTermDeviceRequest.class);
    }
}

