package org.yiwan.seiya.phoenix.bss.app.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.yiwan.seiya.phoenix.bss.app.model.TerminalDeviceModel;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 税控底账服务器入参
 */
@ApiModel(description = "税控底账服务器入参")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-04-02T13:56:39.203+08:00")
public class UpdateTermRequest   {
    @JsonProperty("deployType")
    private String deployType = null;

    @JsonProperty("deviceModels")
    @Valid
    private List<TerminalDeviceModel> deviceModels = null;

    @JsonProperty("originAccountTerminalId")
    private String originAccountTerminalId = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("supportService")
    private String supportService = null;

    @JsonProperty("terminalMode")
    private String terminalMode = null;

    @JsonProperty("terminalNo")
    private String terminalNo = null;

    public UpdateTermRequest withDeployType(String deployType) {
        this.deployType = deployType;
        return this;
    }

    /**
    * 部署类型，1 票易通部署 2 非票易通部署
    * @return deployType
    **/
    @ApiModelProperty(value = "部署类型，1 票易通部署 2 非票易通部署")


    public String getDeployType() {
        return deployType;
    }

    public void setDeployType(String deployType) {
        this.deployType = deployType;
    }

    public UpdateTermRequest withDeviceModels(List<TerminalDeviceModel> deviceModels) {
        this.deviceModels = deviceModels;
        return this;
    }

    public UpdateTermRequest withDeviceModelsAdd(TerminalDeviceModel deviceModels) {
        if (this.deviceModels == null) {
            this.deviceModels = new ArrayList<TerminalDeviceModel>();
        }
        this.deviceModels.add(deviceModels);
        return this;
    }

    /**
    * 设备信息集合  包含公司及对应设备详情
    * @return deviceModels
    **/
    @ApiModelProperty(value = "设备信息集合  包含公司及对应设备详情")

  @Valid

    public List<TerminalDeviceModel> getDeviceModels() {
        return deviceModels;
    }

    public void setDeviceModels(List<TerminalDeviceModel> deviceModels) {
        this.deviceModels = deviceModels;
    }

    public UpdateTermRequest withOriginAccountTerminalId(String originAccountTerminalId) {
        this.originAccountTerminalId = originAccountTerminalId;
        return this;
    }

    /**
    * 终端id
    * @return originAccountTerminalId
    **/
    @ApiModelProperty(value = "终端id")


    public String getOriginAccountTerminalId() {
        return originAccountTerminalId;
    }

    public void setOriginAccountTerminalId(String originAccountTerminalId) {
        this.originAccountTerminalId = originAccountTerminalId;
    }

    public UpdateTermRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public UpdateTermRequest withSupportService(String supportService) {
        this.supportService = supportService;
        return this;
    }

    /**
    * 支持的服务（print:打印 make:开票,originAccount:底账,assistant：辅助）
    * @return supportService
    **/
    @ApiModelProperty(value = "支持的服务（print:打印 make:开票,originAccount:底账,assistant：辅助）")


    public String getSupportService() {
        return supportService;
    }

    public void setSupportService(String supportService) {
        this.supportService = supportService;
    }

    public UpdateTermRequest withTerminalMode(String terminalMode) {
        this.terminalMode = terminalMode;
        return this;
    }

    /**
    * 终端物理设备类型，2 百望服务器 4 航信服务器
    * @return terminalMode
    **/
    @ApiModelProperty(value = "终端物理设备类型，2 百望服务器 4 航信服务器")


    public String getTerminalMode() {
        return terminalMode;
    }

    public void setTerminalMode(String terminalMode) {
        this.terminalMode = terminalMode;
    }

    public UpdateTermRequest withTerminalNo(String terminalNo) {
        this.terminalNo = terminalNo;
        return this;
    }

    /**
    * 终端编号(设备编号)
    * @return terminalNo
    **/
    @ApiModelProperty(value = "终端编号(设备编号)")


    public String getTerminalNo() {
        return terminalNo;
    }

    public void setTerminalNo(String terminalNo) {
        this.terminalNo = terminalNo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UpdateTermRequest updateTermRequest = (UpdateTermRequest) o;
        return Objects.equals(this.deployType, updateTermRequest.deployType) &&
            Objects.equals(this.deviceModels, updateTermRequest.deviceModels) &&
            Objects.equals(this.originAccountTerminalId, updateTermRequest.originAccountTerminalId) &&
            Objects.equals(this.rid, updateTermRequest.rid) &&
            Objects.equals(this.supportService, updateTermRequest.supportService) &&
            Objects.equals(this.terminalMode, updateTermRequest.terminalMode) &&
            Objects.equals(this.terminalNo, updateTermRequest.terminalNo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(deployType, deviceModels, originAccountTerminalId, rid, supportService, terminalMode, terminalNo);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link UpdateTermRequest }.
     */
    public static UpdateTermRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, UpdateTermRequest.class);
    }
}

