package org.yiwan.seiya.phoenix.bss.external.service.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 协同配置
 */
@ApiModel(description = "协同配置")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-03-04T12:25:05.592+08:00")

public class CoordinationModel   {
  @JsonProperty("businessChangedReceiverFlag")
  private Integer businessChangedReceiverFlag = null;

  @JsonProperty("businessChangedSenderFlag")
  private Integer businessChangedSenderFlag = null;

  @JsonProperty("businessType")
  private String businessType = null;

  @JsonProperty("businessUploadPartType")
  private String businessUploadPartType = null;

  @JsonProperty("businessUploadedReceiverFlag")
  private Integer businessUploadedReceiverFlag = null;

  @JsonProperty("businessUploadedSenderFlag")
  private Integer businessUploadedSenderFlag = null;

  @JsonProperty("canUpdateColumns")
  private String canUpdateColumns = null;

  @JsonProperty("combinedDetailFlag")
  private Integer combinedDetailFlag = null;

  @JsonProperty("coordinationRuleId")
  private Long coordinationRuleId = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("diffFieldCannotMerged")
  private String diffFieldCannotMerged = null;

  @JsonProperty("fieldsAddNotes")
  private String fieldsAddNotes = null;

  @JsonProperty("invoicedCertificationCoordinatedSalesFlag")
  private Integer invoicedCertificationCoordinatedSalesFlag = null;

  @JsonProperty("invoicedReturnCoordinatedSalesFlag")
  private Integer invoicedReturnCoordinatedSalesFlag = null;

  @JsonProperty("invoicerPaymentCoordinationPurchaserFlag")
  private Integer invoicerPaymentCoordinationPurchaserFlag = null;

  @JsonProperty("modifiableContent")
  private String modifiableContent = null;

  @JsonProperty("operateReason")
  private String operateReason = null;

  @JsonProperty("orgStructId")
  private Long orgStructId = null;

  @JsonProperty("preinvoiceChangedReceiverFlag")
  private Integer preinvoiceChangedReceiverFlag = null;

  @JsonProperty("preinvoiceChangedSenderFlag")
  private Integer preinvoiceChangedSenderFlag = null;

  @JsonProperty("preinvoiceReceiverFlag")
  private Integer preinvoiceReceiverFlag = null;

  @JsonProperty("preinvoiceSenderFlag")
  private Integer preinvoiceSenderFlag = null;

  @JsonProperty("purchaserCompanyId")
  private Long purchaserCompanyId = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonProperty("purchaserPushSellerFlag")
  private Integer purchaserPushSellerFlag = null;

  @JsonProperty("receiverDocField")
  private String receiverDocField = null;

  @JsonProperty("reviseNotesFlag")
  private Integer reviseNotesFlag = null;

  @JsonProperty("sellerCompanyId")
  private Long sellerCompanyId = null;

  @JsonProperty("sellerGroupId")
  private Long sellerGroupId = null;

  @JsonProperty("separationDetailsFlag")
  private Integer separationDetailsFlag = null;

  @JsonProperty("separationRule")
  private String separationRule = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("statusTime")
  private String statusTime = null;

  @JsonProperty("updateBusinessFlag")
  private Integer updateBusinessFlag = null;

  public CoordinationModel businessChangedReceiverFlag(Integer businessChangedReceiverFlag) {
    this.businessChangedReceiverFlag = businessChangedReceiverFlag;
    return this;
  }

   /**
   * 业务单有变更后接收方是否自动确认 1:是  0:否
   * @return businessChangedReceiverFlag
  **/
  @ApiModelProperty(value = "业务单有变更后接收方是否自动确认 1:是  0:否")


  public Integer getBusinessChangedReceiverFlag() {
    return businessChangedReceiverFlag;
  }

  public void setBusinessChangedReceiverFlag(Integer businessChangedReceiverFlag) {
    this.businessChangedReceiverFlag = businessChangedReceiverFlag;
  }

  public CoordinationModel businessChangedSenderFlag(Integer businessChangedSenderFlag) {
    this.businessChangedSenderFlag = businessChangedSenderFlag;
    return this;
  }

   /**
   * 业务单有变更后上传方是否自动确认 1:是  0:否
   * @return businessChangedSenderFlag
  **/
  @ApiModelProperty(value = "业务单有变更后上传方是否自动确认 1:是  0:否")


  public Integer getBusinessChangedSenderFlag() {
    return businessChangedSenderFlag;
  }

  public void setBusinessChangedSenderFlag(Integer businessChangedSenderFlag) {
    this.businessChangedSenderFlag = businessChangedSenderFlag;
  }

  public CoordinationModel businessType(String businessType) {
    this.businessType = businessType;
    return this;
  }

   /**
   * 业务单类型 从销项接口获取,根据业务单上传方确定元数据
   * @return businessType
  **/
  @ApiModelProperty(value = "业务单类型 从销项接口获取,根据业务单上传方确定元数据")


  public String getBusinessType() {
    return businessType;
  }

  public void setBusinessType(String businessType) {
    this.businessType = businessType;
  }

  public CoordinationModel businessUploadPartType(String businessUploadPartType) {
    this.businessUploadPartType = businessUploadPartType;
    return this;
  }

   /**
   * 业务单上传方类型   AR:销方  AP:购方
   * @return businessUploadPartType
  **/
  @ApiModelProperty(value = "业务单上传方类型   AR:销方  AP:购方")


  public String getBusinessUploadPartType() {
    return businessUploadPartType;
  }

  public void setBusinessUploadPartType(String businessUploadPartType) {
    this.businessUploadPartType = businessUploadPartType;
  }

  public CoordinationModel businessUploadedReceiverFlag(Integer businessUploadedReceiverFlag) {
    this.businessUploadedReceiverFlag = businessUploadedReceiverFlag;
    return this;
  }

   /**
   * 业务单上传后接收方是否自动确认  1:是  0:否
   * @return businessUploadedReceiverFlag
  **/
  @ApiModelProperty(value = "业务单上传后接收方是否自动确认  1:是  0:否")


  public Integer getBusinessUploadedReceiverFlag() {
    return businessUploadedReceiverFlag;
  }

  public void setBusinessUploadedReceiverFlag(Integer businessUploadedReceiverFlag) {
    this.businessUploadedReceiverFlag = businessUploadedReceiverFlag;
  }

  public CoordinationModel businessUploadedSenderFlag(Integer businessUploadedSenderFlag) {
    this.businessUploadedSenderFlag = businessUploadedSenderFlag;
    return this;
  }

   /**
   * 业务单上传后上传方是否自动确认  1:是  0:否
   * @return businessUploadedSenderFlag
  **/
  @ApiModelProperty(value = "业务单上传后上传方是否自动确认  1:是  0:否")


  public Integer getBusinessUploadedSenderFlag() {
    return businessUploadedSenderFlag;
  }

  public void setBusinessUploadedSenderFlag(Integer businessUploadedSenderFlag) {
    this.businessUploadedSenderFlag = businessUploadedSenderFlag;
  }

  public CoordinationModel canUpdateColumns(String canUpdateColumns) {
    this.canUpdateColumns = canUpdateColumns;
    return this;
  }

   /**
   * 可以修改的字段
   * @return canUpdateColumns
  **/
  @ApiModelProperty(value = "可以修改的字段")


  public String getCanUpdateColumns() {
    return canUpdateColumns;
  }

  public void setCanUpdateColumns(String canUpdateColumns) {
    this.canUpdateColumns = canUpdateColumns;
  }

  public CoordinationModel combinedDetailFlag(Integer combinedDetailFlag) {
    this.combinedDetailFlag = combinedDetailFlag;
    return this;
  }

   /**
   * 是否合并明细 0:否 1:是
   * @return combinedDetailFlag
  **/
  @ApiModelProperty(value = "是否合并明细 0:否 1:是")


  public Integer getCombinedDetailFlag() {
    return combinedDetailFlag;
  }

  public void setCombinedDetailFlag(Integer combinedDetailFlag) {
    this.combinedDetailFlag = combinedDetailFlag;
  }

  public CoordinationModel coordinationRuleId(Long coordinationRuleId) {
    this.coordinationRuleId = coordinationRuleId;
    return this;
  }

   /**
   * 主键id
   * @return coordinationRuleId
  **/
  @ApiModelProperty(value = "主键id")


  public Long getCoordinationRuleId() {
    return coordinationRuleId;
  }

  public void setCoordinationRuleId(Long coordinationRuleId) {
    this.coordinationRuleId = coordinationRuleId;
  }

  public CoordinationModel createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")


  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  public CoordinationModel diffFieldCannotMerged(String diffFieldCannotMerged) {
    this.diffFieldCannotMerged = diffFieldCannotMerged;
    return this;
  }

   /**
   * 这些字段值不同不可合并
   * @return diffFieldCannotMerged
  **/
  @ApiModelProperty(value = "这些字段值不同不可合并")


  public String getDiffFieldCannotMerged() {
    return diffFieldCannotMerged;
  }

  public void setDiffFieldCannotMerged(String diffFieldCannotMerged) {
    this.diffFieldCannotMerged = diffFieldCannotMerged;
  }

  public CoordinationModel fieldsAddNotes(String fieldsAddNotes) {
    this.fieldsAddNotes = fieldsAddNotes;
    return this;
  }

   /**
   * 需要加入业务单备注的字段
   * @return fieldsAddNotes
  **/
  @ApiModelProperty(value = "需要加入业务单备注的字段")


  public String getFieldsAddNotes() {
    return fieldsAddNotes;
  }

  public void setFieldsAddNotes(String fieldsAddNotes) {
    this.fieldsAddNotes = fieldsAddNotes;
  }

  public CoordinationModel invoicedCertificationCoordinatedSalesFlag(Integer invoicedCertificationCoordinatedSalesFlag) {
    this.invoicedCertificationCoordinatedSalesFlag = invoicedCertificationCoordinatedSalesFlag;
    return this;
  }

   /**
   * 进项发票认证后是否协同给销项  1:是 0:否
   * @return invoicedCertificationCoordinatedSalesFlag
  **/
  @ApiModelProperty(value = "进项发票认证后是否协同给销项  1:是 0:否")


  public Integer getInvoicedCertificationCoordinatedSalesFlag() {
    return invoicedCertificationCoordinatedSalesFlag;
  }

  public void setInvoicedCertificationCoordinatedSalesFlag(Integer invoicedCertificationCoordinatedSalesFlag) {
    this.invoicedCertificationCoordinatedSalesFlag = invoicedCertificationCoordinatedSalesFlag;
  }

  public CoordinationModel invoicedReturnCoordinatedSalesFlag(Integer invoicedReturnCoordinatedSalesFlag) {
    this.invoicedReturnCoordinatedSalesFlag = invoicedReturnCoordinatedSalesFlag;
    return this;
  }

   /**
   * 进项发票退回是否协同给销项  1:是 0:否
   * @return invoicedReturnCoordinatedSalesFlag
  **/
  @ApiModelProperty(value = "进项发票退回是否协同给销项  1:是 0:否")


  public Integer getInvoicedReturnCoordinatedSalesFlag() {
    return invoicedReturnCoordinatedSalesFlag;
  }

  public void setInvoicedReturnCoordinatedSalesFlag(Integer invoicedReturnCoordinatedSalesFlag) {
    this.invoicedReturnCoordinatedSalesFlag = invoicedReturnCoordinatedSalesFlag;
  }

  public CoordinationModel invoicerPaymentCoordinationPurchaserFlag(Integer invoicerPaymentCoordinationPurchaserFlag) {
    this.invoicerPaymentCoordinationPurchaserFlag = invoicerPaymentCoordinationPurchaserFlag;
    return this;
  }

   /**
   * 进项发票付款状态是否协同给购方 1:是  0:否
   * @return invoicerPaymentCoordinationPurchaserFlag
  **/
  @ApiModelProperty(value = "进项发票付款状态是否协同给购方 1:是  0:否")


  public Integer getInvoicerPaymentCoordinationPurchaserFlag() {
    return invoicerPaymentCoordinationPurchaserFlag;
  }

  public void setInvoicerPaymentCoordinationPurchaserFlag(Integer invoicerPaymentCoordinationPurchaserFlag) {
    this.invoicerPaymentCoordinationPurchaserFlag = invoicerPaymentCoordinationPurchaserFlag;
  }

  public CoordinationModel modifiableContent(String modifiableContent) {
    this.modifiableContent = modifiableContent;
    return this;
  }

   /**
   * 可变更内容
   * @return modifiableContent
  **/
  @ApiModelProperty(value = "可变更内容")


  public String getModifiableContent() {
    return modifiableContent;
  }

  public void setModifiableContent(String modifiableContent) {
    this.modifiableContent = modifiableContent;
  }

  public CoordinationModel operateReason(String operateReason) {
    this.operateReason = operateReason;
    return this;
  }

   /**
   * 注销/启用原因
   * @return operateReason
  **/
  @ApiModelProperty(value = "注销/启用原因")


  public String getOperateReason() {
    return operateReason;
  }

  public void setOperateReason(String operateReason) {
    this.operateReason = operateReason;
  }

  public CoordinationModel orgStructId(Long orgStructId) {
    this.orgStructId = orgStructId;
    return this;
  }

   /**
   * 子组织id
   * @return orgStructId
  **/
  @ApiModelProperty(value = "子组织id")


  public Long getOrgStructId() {
    return orgStructId;
  }

  public void setOrgStructId(Long orgStructId) {
    this.orgStructId = orgStructId;
  }

  public CoordinationModel preinvoiceChangedReceiverFlag(Integer preinvoiceChangedReceiverFlag) {
    this.preinvoiceChangedReceiverFlag = preinvoiceChangedReceiverFlag;
    return this;
  }

   /**
   * 预制发票有变更接收方自动确认 1:是 0:否
   * @return preinvoiceChangedReceiverFlag
  **/
  @ApiModelProperty(value = "预制发票有变更接收方自动确认 1:是 0:否")


  public Integer getPreinvoiceChangedReceiverFlag() {
    return preinvoiceChangedReceiverFlag;
  }

  public void setPreinvoiceChangedReceiverFlag(Integer preinvoiceChangedReceiverFlag) {
    this.preinvoiceChangedReceiverFlag = preinvoiceChangedReceiverFlag;
  }

  public CoordinationModel preinvoiceChangedSenderFlag(Integer preinvoiceChangedSenderFlag) {
    this.preinvoiceChangedSenderFlag = preinvoiceChangedSenderFlag;
    return this;
  }

   /**
   * 预制发票有变更上传方自动确认 1:是 0:否
   * @return preinvoiceChangedSenderFlag
  **/
  @ApiModelProperty(value = "预制发票有变更上传方自动确认 1:是 0:否")


  public Integer getPreinvoiceChangedSenderFlag() {
    return preinvoiceChangedSenderFlag;
  }

  public void setPreinvoiceChangedSenderFlag(Integer preinvoiceChangedSenderFlag) {
    this.preinvoiceChangedSenderFlag = preinvoiceChangedSenderFlag;
  }

  public CoordinationModel preinvoiceReceiverFlag(Integer preinvoiceReceiverFlag) {
    this.preinvoiceReceiverFlag = preinvoiceReceiverFlag;
    return this;
  }

   /**
   * 预制发票生成后接收方是否自动确认 1:是  0:否
   * @return preinvoiceReceiverFlag
  **/
  @ApiModelProperty(value = "预制发票生成后接收方是否自动确认 1:是  0:否")


  public Integer getPreinvoiceReceiverFlag() {
    return preinvoiceReceiverFlag;
  }

  public void setPreinvoiceReceiverFlag(Integer preinvoiceReceiverFlag) {
    this.preinvoiceReceiverFlag = preinvoiceReceiverFlag;
  }

  public CoordinationModel preinvoiceSenderFlag(Integer preinvoiceSenderFlag) {
    this.preinvoiceSenderFlag = preinvoiceSenderFlag;
    return this;
  }

   /**
   * 预制发票创建后上传方自动确认  1:是  0:否
   * @return preinvoiceSenderFlag
  **/
  @ApiModelProperty(value = "预制发票创建后上传方自动确认  1:是  0:否")


  public Integer getPreinvoiceSenderFlag() {
    return preinvoiceSenderFlag;
  }

  public void setPreinvoiceSenderFlag(Integer preinvoiceSenderFlag) {
    this.preinvoiceSenderFlag = preinvoiceSenderFlag;
  }

  public CoordinationModel purchaserCompanyId(Long purchaserCompanyId) {
    this.purchaserCompanyId = purchaserCompanyId;
    return this;
  }

   /**
   * 购方公司id(根据公司税号/公司名称获取)
   * @return purchaserCompanyId
  **/
  @ApiModelProperty(value = "购方公司id(根据公司税号/公司名称获取)")


  public Long getPurchaserCompanyId() {
    return purchaserCompanyId;
  }

  public void setPurchaserCompanyId(Long purchaserCompanyId) {
    this.purchaserCompanyId = purchaserCompanyId;
  }

  public CoordinationModel purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 购方集团id
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "购方集团id")


  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }

  public CoordinationModel purchaserPushSellerFlag(Integer purchaserPushSellerFlag) {
    this.purchaserPushSellerFlag = purchaserPushSellerFlag;
    return this;
  }

   /**
   * 是否要推送购方申请的红字信息到销方 1:是 0:否
   * @return purchaserPushSellerFlag
  **/
  @ApiModelProperty(value = "是否要推送购方申请的红字信息到销方 1:是 0:否")


  public Integer getPurchaserPushSellerFlag() {
    return purchaserPushSellerFlag;
  }

  public void setPurchaserPushSellerFlag(Integer purchaserPushSellerFlag) {
    this.purchaserPushSellerFlag = purchaserPushSellerFlag;
  }

  public CoordinationModel receiverDocField(String receiverDocField) {
    this.receiverDocField = receiverDocField;
    return this;
  }

   /**
   * 接收方可见单据字段
   * @return receiverDocField
  **/
  @ApiModelProperty(value = "接收方可见单据字段")


  public String getReceiverDocField() {
    return receiverDocField;
  }

  public void setReceiverDocField(String receiverDocField) {
    this.receiverDocField = receiverDocField;
  }

  public CoordinationModel reviseNotesFlag(Integer reviseNotesFlag) {
    this.reviseNotesFlag = reviseNotesFlag;
    return this;
  }

   /**
   * 是否修改备注 0:否 1:是
   * @return reviseNotesFlag
  **/
  @ApiModelProperty(value = "是否修改备注 0:否 1:是")


  public Integer getReviseNotesFlag() {
    return reviseNotesFlag;
  }

  public void setReviseNotesFlag(Integer reviseNotesFlag) {
    this.reviseNotesFlag = reviseNotesFlag;
  }

  public CoordinationModel sellerCompanyId(Long sellerCompanyId) {
    this.sellerCompanyId = sellerCompanyId;
    return this;
  }

   /**
   * 销方公司id(根据公司税号/公司名称获取)
   * @return sellerCompanyId
  **/
  @ApiModelProperty(value = "销方公司id(根据公司税号/公司名称获取)")


  public Long getSellerCompanyId() {
    return sellerCompanyId;
  }

  public void setSellerCompanyId(Long sellerCompanyId) {
    this.sellerCompanyId = sellerCompanyId;
  }

  public CoordinationModel sellerGroupId(Long sellerGroupId) {
    this.sellerGroupId = sellerGroupId;
    return this;
  }

   /**
   * 销方集团id
   * @return sellerGroupId
  **/
  @ApiModelProperty(value = "销方集团id")


  public Long getSellerGroupId() {
    return sellerGroupId;
  }

  public void setSellerGroupId(Long sellerGroupId) {
    this.sellerGroupId = sellerGroupId;
  }

  public CoordinationModel separationDetailsFlag(Integer separationDetailsFlag) {
    this.separationDetailsFlag = separationDetailsFlag;
    return this;
  }

   /**
   * 是否显示拆分明细 0:否 1:是
   * @return separationDetailsFlag
  **/
  @ApiModelProperty(value = "是否显示拆分明细 0:否 1:是")


  public Integer getSeparationDetailsFlag() {
    return separationDetailsFlag;
  }

  public void setSeparationDetailsFlag(Integer separationDetailsFlag) {
    this.separationDetailsFlag = separationDetailsFlag;
  }

  public CoordinationModel separationRule(String separationRule) {
    this.separationRule = separationRule;
    return this;
  }

   /**
   * 拆分规则(下拉框获取)
   * @return separationRule
  **/
  @ApiModelProperty(value = "拆分规则(下拉框获取)")


  public String getSeparationRule() {
    return separationRule;
  }

  public void setSeparationRule(String separationRule) {
    this.separationRule = separationRule;
  }

  public CoordinationModel status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 关联状态：1：正常，0：注销
   * @return status
  **/
  @ApiModelProperty(value = "关联状态：1：正常，0：注销")


  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  public CoordinationModel statusTime(String statusTime) {
    this.statusTime = statusTime;
    return this;
  }

   /**
   * 状态变更时间
   * @return statusTime
  **/
  @ApiModelProperty(value = "状态变更时间")


  public String getStatusTime() {
    return statusTime;
  }

  public void setStatusTime(String statusTime) {
    this.statusTime = statusTime;
  }

  public CoordinationModel updateBusinessFlag(Integer updateBusinessFlag) {
    this.updateBusinessFlag = updateBusinessFlag;
    return this;
  }

   /**
   * 是否修改业务单 0:否 1:是
   * @return updateBusinessFlag
  **/
  @ApiModelProperty(value = "是否修改业务单 0:否 1:是")


  public Integer getUpdateBusinessFlag() {
    return updateBusinessFlag;
  }

  public void setUpdateBusinessFlag(Integer updateBusinessFlag) {
    this.updateBusinessFlag = updateBusinessFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CoordinationModel coordinationModel = (CoordinationModel) o;
    return Objects.equals(this.businessChangedReceiverFlag, coordinationModel.businessChangedReceiverFlag) &&
        Objects.equals(this.businessChangedSenderFlag, coordinationModel.businessChangedSenderFlag) &&
        Objects.equals(this.businessType, coordinationModel.businessType) &&
        Objects.equals(this.businessUploadPartType, coordinationModel.businessUploadPartType) &&
        Objects.equals(this.businessUploadedReceiverFlag, coordinationModel.businessUploadedReceiverFlag) &&
        Objects.equals(this.businessUploadedSenderFlag, coordinationModel.businessUploadedSenderFlag) &&
        Objects.equals(this.canUpdateColumns, coordinationModel.canUpdateColumns) &&
        Objects.equals(this.combinedDetailFlag, coordinationModel.combinedDetailFlag) &&
        Objects.equals(this.coordinationRuleId, coordinationModel.coordinationRuleId) &&
        Objects.equals(this.createTime, coordinationModel.createTime) &&
        Objects.equals(this.diffFieldCannotMerged, coordinationModel.diffFieldCannotMerged) &&
        Objects.equals(this.fieldsAddNotes, coordinationModel.fieldsAddNotes) &&
        Objects.equals(this.invoicedCertificationCoordinatedSalesFlag, coordinationModel.invoicedCertificationCoordinatedSalesFlag) &&
        Objects.equals(this.invoicedReturnCoordinatedSalesFlag, coordinationModel.invoicedReturnCoordinatedSalesFlag) &&
        Objects.equals(this.invoicerPaymentCoordinationPurchaserFlag, coordinationModel.invoicerPaymentCoordinationPurchaserFlag) &&
        Objects.equals(this.modifiableContent, coordinationModel.modifiableContent) &&
        Objects.equals(this.operateReason, coordinationModel.operateReason) &&
        Objects.equals(this.orgStructId, coordinationModel.orgStructId) &&
        Objects.equals(this.preinvoiceChangedReceiverFlag, coordinationModel.preinvoiceChangedReceiverFlag) &&
        Objects.equals(this.preinvoiceChangedSenderFlag, coordinationModel.preinvoiceChangedSenderFlag) &&
        Objects.equals(this.preinvoiceReceiverFlag, coordinationModel.preinvoiceReceiverFlag) &&
        Objects.equals(this.preinvoiceSenderFlag, coordinationModel.preinvoiceSenderFlag) &&
        Objects.equals(this.purchaserCompanyId, coordinationModel.purchaserCompanyId) &&
        Objects.equals(this.purchaserGroupId, coordinationModel.purchaserGroupId) &&
        Objects.equals(this.purchaserPushSellerFlag, coordinationModel.purchaserPushSellerFlag) &&
        Objects.equals(this.receiverDocField, coordinationModel.receiverDocField) &&
        Objects.equals(this.reviseNotesFlag, coordinationModel.reviseNotesFlag) &&
        Objects.equals(this.sellerCompanyId, coordinationModel.sellerCompanyId) &&
        Objects.equals(this.sellerGroupId, coordinationModel.sellerGroupId) &&
        Objects.equals(this.separationDetailsFlag, coordinationModel.separationDetailsFlag) &&
        Objects.equals(this.separationRule, coordinationModel.separationRule) &&
        Objects.equals(this.status, coordinationModel.status) &&
        Objects.equals(this.statusTime, coordinationModel.statusTime) &&
        Objects.equals(this.updateBusinessFlag, coordinationModel.updateBusinessFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessChangedReceiverFlag, businessChangedSenderFlag, businessType, businessUploadPartType, businessUploadedReceiverFlag, businessUploadedSenderFlag, canUpdateColumns, combinedDetailFlag, coordinationRuleId, createTime, diffFieldCannotMerged, fieldsAddNotes, invoicedCertificationCoordinatedSalesFlag, invoicedReturnCoordinatedSalesFlag, invoicerPaymentCoordinationPurchaserFlag, modifiableContent, operateReason, orgStructId, preinvoiceChangedReceiverFlag, preinvoiceChangedSenderFlag, preinvoiceReceiverFlag, preinvoiceSenderFlag, purchaserCompanyId, purchaserGroupId, purchaserPushSellerFlag, receiverDocField, reviseNotesFlag, sellerCompanyId, sellerGroupId, separationDetailsFlag, separationRule, status, statusTime, updateBusinessFlag);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CoordinationModel {\n");
    
    sb.append("    businessChangedReceiverFlag: ").append(toIndentedString(businessChangedReceiverFlag)).append("\n");
    sb.append("    businessChangedSenderFlag: ").append(toIndentedString(businessChangedSenderFlag)).append("\n");
    sb.append("    businessType: ").append(toIndentedString(businessType)).append("\n");
    sb.append("    businessUploadPartType: ").append(toIndentedString(businessUploadPartType)).append("\n");
    sb.append("    businessUploadedReceiverFlag: ").append(toIndentedString(businessUploadedReceiverFlag)).append("\n");
    sb.append("    businessUploadedSenderFlag: ").append(toIndentedString(businessUploadedSenderFlag)).append("\n");
    sb.append("    canUpdateColumns: ").append(toIndentedString(canUpdateColumns)).append("\n");
    sb.append("    combinedDetailFlag: ").append(toIndentedString(combinedDetailFlag)).append("\n");
    sb.append("    coordinationRuleId: ").append(toIndentedString(coordinationRuleId)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    diffFieldCannotMerged: ").append(toIndentedString(diffFieldCannotMerged)).append("\n");
    sb.append("    fieldsAddNotes: ").append(toIndentedString(fieldsAddNotes)).append("\n");
    sb.append("    invoicedCertificationCoordinatedSalesFlag: ").append(toIndentedString(invoicedCertificationCoordinatedSalesFlag)).append("\n");
    sb.append("    invoicedReturnCoordinatedSalesFlag: ").append(toIndentedString(invoicedReturnCoordinatedSalesFlag)).append("\n");
    sb.append("    invoicerPaymentCoordinationPurchaserFlag: ").append(toIndentedString(invoicerPaymentCoordinationPurchaserFlag)).append("\n");
    sb.append("    modifiableContent: ").append(toIndentedString(modifiableContent)).append("\n");
    sb.append("    operateReason: ").append(toIndentedString(operateReason)).append("\n");
    sb.append("    orgStructId: ").append(toIndentedString(orgStructId)).append("\n");
    sb.append("    preinvoiceChangedReceiverFlag: ").append(toIndentedString(preinvoiceChangedReceiverFlag)).append("\n");
    sb.append("    preinvoiceChangedSenderFlag: ").append(toIndentedString(preinvoiceChangedSenderFlag)).append("\n");
    sb.append("    preinvoiceReceiverFlag: ").append(toIndentedString(preinvoiceReceiverFlag)).append("\n");
    sb.append("    preinvoiceSenderFlag: ").append(toIndentedString(preinvoiceSenderFlag)).append("\n");
    sb.append("    purchaserCompanyId: ").append(toIndentedString(purchaserCompanyId)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("    purchaserPushSellerFlag: ").append(toIndentedString(purchaserPushSellerFlag)).append("\n");
    sb.append("    receiverDocField: ").append(toIndentedString(receiverDocField)).append("\n");
    sb.append("    reviseNotesFlag: ").append(toIndentedString(reviseNotesFlag)).append("\n");
    sb.append("    sellerCompanyId: ").append(toIndentedString(sellerCompanyId)).append("\n");
    sb.append("    sellerGroupId: ").append(toIndentedString(sellerGroupId)).append("\n");
    sb.append("    separationDetailsFlag: ").append(toIndentedString(separationDetailsFlag)).append("\n");
    sb.append("    separationRule: ").append(toIndentedString(separationRule)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    statusTime: ").append(toIndentedString(statusTime)).append("\n");
    sb.append("    updateBusinessFlag: ").append(toIndentedString(updateBusinessFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

