package org.yiwan.seiya.phoenix.bss.external.service.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-03-04T12:25:05.592+08:00")

public class GetCoordinationInfoRequest   {
  @JsonProperty("appid")
  private String appid = null;

  @JsonProperty("businessType")
  private String businessType = null;

  @JsonProperty("businessUploadPartType")
  private String businessUploadPartType = null;

  @JsonProperty("purchaserCompanyId")
  private Long purchaserCompanyId = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonProperty("rid")
  private String rid = null;

  @JsonProperty("sellerCompanyId")
  private Long sellerCompanyId = null;

  @JsonProperty("sellerGroupId")
  private Long sellerGroupId = null;

  public GetCoordinationInfoRequest appid(String appid) {
    this.appid = appid;
    return this;
  }

   /**
   * 请求应用ID
   * @return appid
  **/
  @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


  public String getAppid() {
    return appid;
  }

  public void setAppid(String appid) {
    this.appid = appid;
  }

  public GetCoordinationInfoRequest businessType(String businessType) {
    this.businessType = businessType;
    return this;
  }

   /**
   * 业务单类型
   * @return businessType
  **/
  @ApiModelProperty(value = "业务单类型")


  public String getBusinessType() {
    return businessType;
  }

  public void setBusinessType(String businessType) {
    this.businessType = businessType;
  }

  public GetCoordinationInfoRequest businessUploadPartType(String businessUploadPartType) {
    this.businessUploadPartType = businessUploadPartType;
    return this;
  }

   /**
   * 业务单上传方   AR:销方  AP:购方
   * @return businessUploadPartType
  **/
  @ApiModelProperty(value = "业务单上传方   AR:销方  AP:购方")


  public String getBusinessUploadPartType() {
    return businessUploadPartType;
  }

  public void setBusinessUploadPartType(String businessUploadPartType) {
    this.businessUploadPartType = businessUploadPartType;
  }

  public GetCoordinationInfoRequest purchaserCompanyId(Long purchaserCompanyId) {
    this.purchaserCompanyId = purchaserCompanyId;
    return this;
  }

   /**
   * 购方公司id
   * @return purchaserCompanyId
  **/
  @ApiModelProperty(value = "购方公司id")


  public Long getPurchaserCompanyId() {
    return purchaserCompanyId;
  }

  public void setPurchaserCompanyId(Long purchaserCompanyId) {
    this.purchaserCompanyId = purchaserCompanyId;
  }

  public GetCoordinationInfoRequest purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 购方集团id
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "购方集团id")


  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }

  public GetCoordinationInfoRequest rid(String rid) {
    this.rid = rid;
    return this;
  }

   /**
   * 请求ID
   * @return rid
  **/
  @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


  public String getRid() {
    return rid;
  }

  public void setRid(String rid) {
    this.rid = rid;
  }

  public GetCoordinationInfoRequest sellerCompanyId(Long sellerCompanyId) {
    this.sellerCompanyId = sellerCompanyId;
    return this;
  }

   /**
   * 销方公司id
   * @return sellerCompanyId
  **/
  @ApiModelProperty(value = "销方公司id")


  public Long getSellerCompanyId() {
    return sellerCompanyId;
  }

  public void setSellerCompanyId(Long sellerCompanyId) {
    this.sellerCompanyId = sellerCompanyId;
  }

  public GetCoordinationInfoRequest sellerGroupId(Long sellerGroupId) {
    this.sellerGroupId = sellerGroupId;
    return this;
  }

   /**
   * 销方集团id
   * @return sellerGroupId
  **/
  @ApiModelProperty(value = "销方集团id")


  public Long getSellerGroupId() {
    return sellerGroupId;
  }

  public void setSellerGroupId(Long sellerGroupId) {
    this.sellerGroupId = sellerGroupId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetCoordinationInfoRequest getCoordinationInfoRequest = (GetCoordinationInfoRequest) o;
    return Objects.equals(this.appid, getCoordinationInfoRequest.appid) &&
        Objects.equals(this.businessType, getCoordinationInfoRequest.businessType) &&
        Objects.equals(this.businessUploadPartType, getCoordinationInfoRequest.businessUploadPartType) &&
        Objects.equals(this.purchaserCompanyId, getCoordinationInfoRequest.purchaserCompanyId) &&
        Objects.equals(this.purchaserGroupId, getCoordinationInfoRequest.purchaserGroupId) &&
        Objects.equals(this.rid, getCoordinationInfoRequest.rid) &&
        Objects.equals(this.sellerCompanyId, getCoordinationInfoRequest.sellerCompanyId) &&
        Objects.equals(this.sellerGroupId, getCoordinationInfoRequest.sellerGroupId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appid, businessType, businessUploadPartType, purchaserCompanyId, purchaserGroupId, rid, sellerCompanyId, sellerGroupId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetCoordinationInfoRequest {\n");
    
    sb.append("    appid: ").append(toIndentedString(appid)).append("\n");
    sb.append("    businessType: ").append(toIndentedString(businessType)).append("\n");
    sb.append("    businessUploadPartType: ").append(toIndentedString(businessUploadPartType)).append("\n");
    sb.append("    purchaserCompanyId: ").append(toIndentedString(purchaserCompanyId)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("    rid: ").append(toIndentedString(rid)).append("\n");
    sb.append("    sellerCompanyId: ").append(toIndentedString(sellerCompanyId)).append("\n");
    sb.append("    sellerGroupId: ").append(toIndentedString(sellerGroupId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

