package org.yiwan.seiya.phoenix.bss.external.service.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-03-04T12:25:05.592+08:00")

public class SearchCompanyListRequest   {
  @JsonProperty("appid")
  private String appid = null;

  /**
   * 查询参数
   */
  public enum DataTypeEnum {
    COMPANYNAME("COMPANYNAME"),
    
    TAXNUM("TAXNUM");

    private String value;

    DataTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DataTypeEnum fromValue(String text) {
      for (DataTypeEnum b : DataTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("dataType")
  private DataTypeEnum dataType = null;

  @JsonProperty("dataValue")
  private String dataValue = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("rid")
  private String rid = null;

  @JsonProperty("row")
  private Integer row = null;

  public SearchCompanyListRequest appid(String appid) {
    this.appid = appid;
    return this;
  }

   /**
   * 请求应用ID
   * @return appid
  **/
  @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


  public String getAppid() {
    return appid;
  }

  public void setAppid(String appid) {
    this.appid = appid;
  }

  public SearchCompanyListRequest dataType(DataTypeEnum dataType) {
    this.dataType = dataType;
    return this;
  }

   /**
   * 查询参数
   * @return dataType
  **/
  @ApiModelProperty(value = "查询参数")


  public DataTypeEnum getDataType() {
    return dataType;
  }

  public void setDataType(DataTypeEnum dataType) {
    this.dataType = dataType;
  }

  public SearchCompanyListRequest dataValue(String dataValue) {
    this.dataValue = dataValue;
    return this;
  }

   /**
   * 查询值
   * @return dataValue
  **/
  @ApiModelProperty(value = "查询值")


  public String getDataValue() {
    return dataValue;
  }

  public void setDataValue(String dataValue) {
    this.dataValue = dataValue;
  }

  public SearchCompanyListRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团ID
   * @return groupId
  **/
  @ApiModelProperty(value = "集团ID")


  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  public SearchCompanyListRequest page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * 当前页
   * @return page
  **/
  @ApiModelProperty(value = "当前页")


  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  public SearchCompanyListRequest rid(String rid) {
    this.rid = rid;
    return this;
  }

   /**
   * 请求ID
   * @return rid
  **/
  @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


  public String getRid() {
    return rid;
  }

  public void setRid(String rid) {
    this.rid = rid;
  }

  public SearchCompanyListRequest row(Integer row) {
    this.row = row;
    return this;
  }

   /**
   * 每页显示行数
   * @return row
  **/
  @ApiModelProperty(value = "每页显示行数")


  public Integer getRow() {
    return row;
  }

  public void setRow(Integer row) {
    this.row = row;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchCompanyListRequest searchCompanyListRequest = (SearchCompanyListRequest) o;
    return Objects.equals(this.appid, searchCompanyListRequest.appid) &&
        Objects.equals(this.dataType, searchCompanyListRequest.dataType) &&
        Objects.equals(this.dataValue, searchCompanyListRequest.dataValue) &&
        Objects.equals(this.groupId, searchCompanyListRequest.groupId) &&
        Objects.equals(this.page, searchCompanyListRequest.page) &&
        Objects.equals(this.rid, searchCompanyListRequest.rid) &&
        Objects.equals(this.row, searchCompanyListRequest.row);
  }

  @Override
  public int hashCode() {
    return Objects.hash(appid, dataType, dataValue, groupId, page, rid, row);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchCompanyListRequest {\n");
    
    sb.append("    appid: ").append(toIndentedString(appid)).append("\n");
    sb.append("    dataType: ").append(toIndentedString(dataType)).append("\n");
    sb.append("    dataValue: ").append(toIndentedString(dataValue)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    rid: ").append(toIndentedString(rid)).append("\n");
    sb.append("    row: ").append(toIndentedString(row)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

