package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * url和项目归属关系
 */
@ApiModel(description = "url和项目归属关系")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsApiUrlBelongToModel   {
    @JsonProperty("resouceApiUrls")
    @Valid
    private List<String> resouceApiUrls = null;

    @JsonProperty("resourceCode")
    private String resourceCode = null;

    @JsonProperty("resourcePlatForm")
    private Integer resourcePlatForm = null;

    public MsApiUrlBelongToModel withResouceApiUrls(List<String> resouceApiUrls) {
        this.resouceApiUrls = resouceApiUrls;
        return this;
    }

    public MsApiUrlBelongToModel withResouceApiUrlsAdd(String resouceApiUrls) {
        if (this.resouceApiUrls == null) {
            this.resouceApiUrls = new ArrayList<String>();
        }
        this.resouceApiUrls.add(resouceApiUrls);
        return this;
    }

    /**
    * 资源码对应的urls
    * @return resouceApiUrls
    **/
    @ApiModelProperty(value = "资源码对应的urls")


    public List<String> getResouceApiUrls() {
        return resouceApiUrls;
    }

    public void setResouceApiUrls(List<String> resouceApiUrls) {
        this.resouceApiUrls = resouceApiUrls;
    }

    public MsApiUrlBelongToModel withResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
        return this;
    }

    /**
    * 资源码
    * @return resourceCode
    **/
    @ApiModelProperty(value = "资源码")


    public String getResourceCode() {
        return resourceCode;
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
    }

    public MsApiUrlBelongToModel withResourcePlatForm(Integer resourcePlatForm) {
        this.resourcePlatForm = resourcePlatForm;
        return this;
    }

    /**
    * 资源/url归属
    * @return resourcePlatForm
    **/
    @ApiModelProperty(value = "资源/url归属")


    public Integer getResourcePlatForm() {
        return resourcePlatForm;
    }

    public void setResourcePlatForm(Integer resourcePlatForm) {
        this.resourcePlatForm = resourcePlatForm;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsApiUrlBelongToModel msApiUrlBelongToModel = (MsApiUrlBelongToModel) o;
        return Objects.equals(this.resouceApiUrls, msApiUrlBelongToModel.resouceApiUrls) &&
            Objects.equals(this.resourceCode, msApiUrlBelongToModel.resourceCode) &&
            Objects.equals(this.resourcePlatForm, msApiUrlBelongToModel.resourcePlatForm);
    }

    @Override
    public int hashCode() {
        return Objects.hash(resouceApiUrls, resourceCode, resourcePlatForm);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsApiUrlBelongToModel }.
     */
    public static MsApiUrlBelongToModel fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsApiUrlBelongToModel.class);
    }
}

