package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsCheckMenuNameRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("menuId")
    private Long menuId = null;

    @JsonProperty("menuName")
    private String menuName = null;

    @JsonProperty("parentId")
    private Long parentId = null;

    @JsonProperty("rid")
    private String rid = null;

    public MsCheckMenuNameRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsCheckMenuNameRequest withMenuId(Long menuId) {
        this.menuId = menuId;
        return this;
    }

    /**
    * 菜单ID
    * @return menuId
    **/
    @ApiModelProperty(value = "菜单ID")


    public Long getMenuId() {
        return menuId;
    }

    public void setMenuId(Long menuId) {
        this.menuId = menuId;
    }

    public MsCheckMenuNameRequest withMenuName(String menuName) {
        this.menuName = menuName;
        return this;
    }

    /**
    * 菜单名称
    * @return menuName
    **/
    @ApiModelProperty(value = "菜单名称")


    public String getMenuName() {
        return menuName;
    }

    public void setMenuName(String menuName) {
        this.menuName = menuName;
    }

    public MsCheckMenuNameRequest withParentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    /**
    * 父菜单ID
    * @return parentId
    **/
    @ApiModelProperty(value = "父菜单ID")


    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public MsCheckMenuNameRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsCheckMenuNameRequest msCheckMenuNameRequest = (MsCheckMenuNameRequest) o;
        return Objects.equals(this.appid, msCheckMenuNameRequest.appid) &&
            Objects.equals(this.menuId, msCheckMenuNameRequest.menuId) &&
            Objects.equals(this.menuName, msCheckMenuNameRequest.menuName) &&
            Objects.equals(this.parentId, msCheckMenuNameRequest.parentId) &&
            Objects.equals(this.rid, msCheckMenuNameRequest.rid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, menuId, menuName, parentId, rid);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsCheckMenuNameRequest }.
     */
    public static MsCheckMenuNameRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsCheckMenuNameRequest.class);
    }
}

