package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 当缺省集团改为实体集团时 根据集团id删除对应的角色信息，更换和集团相关的groupId
 */
@ApiModel(description = "当缺省集团改为实体集团时 根据集团id删除对应的角色信息，更换和集团相关的groupId")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsDeleteRoleUserRelByGroupIdRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("doDeleteFlag")
    private Boolean doDeleteFlag = null;

  /**
   * 操作类型
   */
  public enum DoTypeEnum {
    I("I"),
    
    D("D");

    private String value;

    DoTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DoTypeEnum fromValue(String text) {
      for (DoTypeEnum b : DoTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("doType")
    private DoTypeEnum doType = null;

    @JsonProperty("newGroupId")
    private Long newGroupId = null;

    @JsonProperty("oldGroupId")
    private Long oldGroupId = null;

    @JsonProperty("operater")
    private String operater = null;

    @JsonProperty("operaterid")
    private String operaterid = null;

    @JsonProperty("rid")
    private String rid = null;

    public MsDeleteRoleUserRelByGroupIdRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(value = "请求应用ID")


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsDeleteRoleUserRelByGroupIdRequest withDoDeleteFlag(Boolean doDeleteFlag) {
        this.doDeleteFlag = doDeleteFlag;
        return this;
    }

    /**
    * 是否删除old集团对应的数据 true：删除 false：更新
    * @return doDeleteFlag
    **/
    @ApiModelProperty(example = "false", value = "是否删除old集团对应的数据 true：删除 false：更新")


    public Boolean isgetDoDeleteFlag() {
        return doDeleteFlag;
    }

    public void setDoDeleteFlag(Boolean doDeleteFlag) {
        this.doDeleteFlag = doDeleteFlag;
    }

    public MsDeleteRoleUserRelByGroupIdRequest withDoType(DoTypeEnum doType) {
        this.doType = doType;
        return this;
    }

    /**
    * 操作类型
    * @return doType
    **/
    @ApiModelProperty(value = "操作类型")


    public DoTypeEnum getDoType() {
        return doType;
    }

    public void setDoType(DoTypeEnum doType) {
        this.doType = doType;
    }

    public MsDeleteRoleUserRelByGroupIdRequest withNewGroupId(Long newGroupId) {
        this.newGroupId = newGroupId;
        return this;
    }

    /**
    * new集团id
    * @return newGroupId
    **/
    @ApiModelProperty(value = "new集团id")


    public Long getNewGroupId() {
        return newGroupId;
    }

    public void setNewGroupId(Long newGroupId) {
        this.newGroupId = newGroupId;
    }

    public MsDeleteRoleUserRelByGroupIdRequest withOldGroupId(Long oldGroupId) {
        this.oldGroupId = oldGroupId;
        return this;
    }

    /**
    * old集团id
    * @return oldGroupId
    **/
    @ApiModelProperty(value = "old集团id")


    public Long getOldGroupId() {
        return oldGroupId;
    }

    public void setOldGroupId(Long oldGroupId) {
        this.oldGroupId = oldGroupId;
    }

    public MsDeleteRoleUserRelByGroupIdRequest withOperater(String operater) {
        this.operater = operater;
        return this;
    }

    /**
    * 操作人
    * @return operater
    **/
    @ApiModelProperty(value = "操作人")


    public String getOperater() {
        return operater;
    }

    public void setOperater(String operater) {
        this.operater = operater;
    }

    public MsDeleteRoleUserRelByGroupIdRequest withOperaterid(String operaterid) {
        this.operaterid = operaterid;
        return this;
    }

    /**
    * 操作人ID
    * @return operaterid
    **/
    @ApiModelProperty(value = "操作人ID")


    public String getOperaterid() {
        return operaterid;
    }

    public void setOperaterid(String operaterid) {
        this.operaterid = operaterid;
    }

    public MsDeleteRoleUserRelByGroupIdRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(value = "请求ID")


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsDeleteRoleUserRelByGroupIdRequest msDeleteRoleUserRelByGroupIdRequest = (MsDeleteRoleUserRelByGroupIdRequest) o;
        return Objects.equals(this.appid, msDeleteRoleUserRelByGroupIdRequest.appid) &&
            Objects.equals(this.doDeleteFlag, msDeleteRoleUserRelByGroupIdRequest.doDeleteFlag) &&
            Objects.equals(this.doType, msDeleteRoleUserRelByGroupIdRequest.doType) &&
            Objects.equals(this.newGroupId, msDeleteRoleUserRelByGroupIdRequest.newGroupId) &&
            Objects.equals(this.oldGroupId, msDeleteRoleUserRelByGroupIdRequest.oldGroupId) &&
            Objects.equals(this.operater, msDeleteRoleUserRelByGroupIdRequest.operater) &&
            Objects.equals(this.operaterid, msDeleteRoleUserRelByGroupIdRequest.operaterid) &&
            Objects.equals(this.rid, msDeleteRoleUserRelByGroupIdRequest.rid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, doDeleteFlag, doType, newGroupId, oldGroupId, operater, operaterid, rid);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsDeleteRoleUserRelByGroupIdRequest }.
     */
    public static MsDeleteRoleUserRelByGroupIdRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsDeleteRoleUserRelByGroupIdRequest.class);
    }
}

