package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetAccountDetailRequest   {
    @JsonProperty("account_id")
    private Long accountId = null;

    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("email")
    private String email = null;

    @JsonProperty("emailOrPhone")
    private String emailOrPhone = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("telPhone")
    private String telPhone = null;

    public MsGetAccountDetailRequest withAccountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    /**
    * ID
    * @return accountId
    **/
    @ApiModelProperty(value = "ID")


    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public MsGetAccountDetailRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetAccountDetailRequest withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
    * 邮箱
    * @return email
    **/
    @ApiModelProperty(value = "邮箱")


    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public MsGetAccountDetailRequest withEmailOrPhone(String emailOrPhone) {
        this.emailOrPhone = emailOrPhone;
        return this;
    }

    /**
    * 邮箱
    * @return emailOrPhone
    **/
    @ApiModelProperty(value = "邮箱")


    public String getEmailOrPhone() {
        return emailOrPhone;
    }

    public void setEmailOrPhone(String emailOrPhone) {
        this.emailOrPhone = emailOrPhone;
    }

    public MsGetAccountDetailRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetAccountDetailRequest withTelPhone(String telPhone) {
        this.telPhone = telPhone;
        return this;
    }

    /**
    * 手机号码
    * @return telPhone
    **/
    @ApiModelProperty(value = "手机号码")


    public String getTelPhone() {
        return telPhone;
    }

    public void setTelPhone(String telPhone) {
        this.telPhone = telPhone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetAccountDetailRequest msGetAccountDetailRequest = (MsGetAccountDetailRequest) o;
        return Objects.equals(this.accountId, msGetAccountDetailRequest.accountId) &&
            Objects.equals(this.appid, msGetAccountDetailRequest.appid) &&
            Objects.equals(this.email, msGetAccountDetailRequest.email) &&
            Objects.equals(this.emailOrPhone, msGetAccountDetailRequest.emailOrPhone) &&
            Objects.equals(this.rid, msGetAccountDetailRequest.rid) &&
            Objects.equals(this.telPhone, msGetAccountDetailRequest.telPhone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(accountId, appid, email, emailOrPhone, rid, telPhone);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetAccountDetailRequest }.
     */
    public static MsGetAccountDetailRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetAccountDetailRequest.class);
    }
}

