package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetAccountListRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("emailOrPhone")
    private String emailOrPhone = null;

    @JsonProperty("page")
    private Integer page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private Integer row = null;

    @JsonProperty("status")
    private Integer status = null;

    public MsGetAccountListRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetAccountListRequest withEmailOrPhone(String emailOrPhone) {
        this.emailOrPhone = emailOrPhone;
        return this;
    }

    /**
    * 手机|邮箱
    * @return emailOrPhone
    **/
    @ApiModelProperty(value = "手机|邮箱")


    public String getEmailOrPhone() {
        return emailOrPhone;
    }

    public void setEmailOrPhone(String emailOrPhone) {
        this.emailOrPhone = emailOrPhone;
    }

    public MsGetAccountListRequest withPage(Integer page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public MsGetAccountListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetAccountListRequest withRow(Integer row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public Integer getRow() {
        return row;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    public MsGetAccountListRequest withStatus(Integer status) {
        this.status = status;
        return this;
    }

    /**
    * 启用状态
    * @return status
    **/
    @ApiModelProperty(value = "启用状态")


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetAccountListRequest msGetAccountListRequest = (MsGetAccountListRequest) o;
        return Objects.equals(this.appid, msGetAccountListRequest.appid) &&
            Objects.equals(this.emailOrPhone, msGetAccountListRequest.emailOrPhone) &&
            Objects.equals(this.page, msGetAccountListRequest.page) &&
            Objects.equals(this.rid, msGetAccountListRequest.rid) &&
            Objects.equals(this.row, msGetAccountListRequest.row) &&
            Objects.equals(this.status, msGetAccountListRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, emailOrPhone, page, rid, row, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetAccountListRequest }.
     */
    public static MsGetAccountListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetAccountListRequest.class);
    }
}

