package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetApiUrlListRequest   {
    @JsonProperty("appid")
    private String appid = null;

  /**
   * 操作类型 USERID根据用户id获取apis RESOURCESETIDS根据功能集ids查询apis SUPERROLE 根据超级管理员角色Id查询apis
   */
  public enum DoTypeEnum {
    USERID("USERID"),
    
    RESOURCESETIDS("RESOURCESETIDS"),
    
    SUPERROLE("SUPERROLE");

    private String value;

    DoTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DoTypeEnum fromValue(String text) {
      for (DoTypeEnum b : DoTypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("doType")
    private DoTypeEnum doType = null;

    @JsonProperty("resourceSetIds")
    @Valid
    private List<Long> resourceSetIds = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("roleId")
    private Long roleId = null;

    @JsonProperty("userId")
    private Long userId = null;

    public MsGetApiUrlListRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetApiUrlListRequest withDoType(DoTypeEnum doType) {
        this.doType = doType;
        return this;
    }

    /**
    * 操作类型 USERID根据用户id获取apis RESOURCESETIDS根据功能集ids查询apis SUPERROLE 根据超级管理员角色Id查询apis
    * @return doType
    **/
    @ApiModelProperty(value = "操作类型 USERID根据用户id获取apis RESOURCESETIDS根据功能集ids查询apis SUPERROLE 根据超级管理员角色Id查询apis")


    public DoTypeEnum getDoType() {
        return doType;
    }

    public void setDoType(DoTypeEnum doType) {
        this.doType = doType;
    }

    public MsGetApiUrlListRequest withResourceSetIds(List<Long> resourceSetIds) {
        this.resourceSetIds = resourceSetIds;
        return this;
    }

    public MsGetApiUrlListRequest withResourceSetIdsAdd(Long resourceSetIds) {
        if (this.resourceSetIds == null) {
            this.resourceSetIds = new ArrayList<Long>();
        }
        this.resourceSetIds.add(resourceSetIds);
        return this;
    }

    /**
    * 功能集Id集合
    * @return resourceSetIds
    **/
    @ApiModelProperty(value = "功能集Id集合")


    public List<Long> getResourceSetIds() {
        return resourceSetIds;
    }

    public void setResourceSetIds(List<Long> resourceSetIds) {
        this.resourceSetIds = resourceSetIds;
    }

    public MsGetApiUrlListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetApiUrlListRequest withRoleId(Long roleId) {
        this.roleId = roleId;
        return this;
    }

    /**
    * 角色id
    * @return roleId
    **/
    @ApiModelProperty(value = "角色id")


    public Long getRoleId() {
        return roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    public MsGetApiUrlListRequest withUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    /**
    * 用户id
    * @return userId
    **/
    @ApiModelProperty(value = "用户id")


    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetApiUrlListRequest msGetApiUrlListRequest = (MsGetApiUrlListRequest) o;
        return Objects.equals(this.appid, msGetApiUrlListRequest.appid) &&
            Objects.equals(this.doType, msGetApiUrlListRequest.doType) &&
            Objects.equals(this.resourceSetIds, msGetApiUrlListRequest.resourceSetIds) &&
            Objects.equals(this.rid, msGetApiUrlListRequest.rid) &&
            Objects.equals(this.roleId, msGetApiUrlListRequest.roleId) &&
            Objects.equals(this.userId, msGetApiUrlListRequest.userId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, doType, resourceSetIds, rid, roleId, userId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetApiUrlListRequest }.
     */
    public static MsGetApiUrlListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetApiUrlListRequest.class);
    }
}

