package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetCompanyIdListRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("groupId")
    private Long groupId = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("userId")
    private Long userId = null;

    public MsGetCompanyIdListRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetCompanyIdListRequest withGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 集团id
    * @return groupId
    **/
    @ApiModelProperty(value = "集团id")


    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public MsGetCompanyIdListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetCompanyIdListRequest withUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    /**
    * 用户id
    * @return userId
    **/
    @ApiModelProperty(value = "用户id")


    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetCompanyIdListRequest msGetCompanyIdListRequest = (MsGetCompanyIdListRequest) o;
        return Objects.equals(this.appid, msGetCompanyIdListRequest.appid) &&
            Objects.equals(this.groupId, msGetCompanyIdListRequest.groupId) &&
            Objects.equals(this.rid, msGetCompanyIdListRequest.rid) &&
            Objects.equals(this.userId, msGetCompanyIdListRequest.userId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, groupId, rid, userId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetCompanyIdListRequest }.
     */
    public static MsGetCompanyIdListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetCompanyIdListRequest.class);
    }
}

