package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetLogListRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("doType")
    private String doType = null;

    @JsonProperty("endDate")
    private String endDate = null;

    @JsonProperty("groupId")
    private Long groupId = null;

    @JsonProperty("logType")
    private String logType = null;

    @JsonProperty("operateName")
    private String operateName = null;

    @JsonProperty("page")
    private Integer page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private Integer row = null;

    @JsonProperty("startDate")
    private String startDate = null;

    @JsonProperty("typeId")
    private String typeId = null;

    public MsGetLogListRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetLogListRequest withDoType(String doType) {
        this.doType = doType;
        return this;
    }

    /**
    * 操作类型
    * @return doType
    **/
    @ApiModelProperty(value = "操作类型")


    public String getDoType() {
        return doType;
    }

    public void setDoType(String doType) {
        this.doType = doType;
    }

    public MsGetLogListRequest withEndDate(String endDate) {
        this.endDate = endDate;
        return this;
    }

    /**
    * 截至日期
    * @return endDate
    **/
    @ApiModelProperty(value = "截至日期")


    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public MsGetLogListRequest withGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 集团ID
    * @return groupId
    **/
    @ApiModelProperty(value = "集团ID")


    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public MsGetLogListRequest withLogType(String logType) {
        this.logType = logType;
        return this;
    }

    /**
    * 日志类型
    * @return logType
    **/
    @ApiModelProperty(value = "日志类型")


    public String getLogType() {
        return logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public MsGetLogListRequest withOperateName(String operateName) {
        this.operateName = operateName;
        return this;
    }

    /**
    * 操作人
    * @return operateName
    **/
    @ApiModelProperty(value = "操作人")


    public String getOperateName() {
        return operateName;
    }

    public void setOperateName(String operateName) {
        this.operateName = operateName;
    }

    public MsGetLogListRequest withPage(Integer page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public MsGetLogListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetLogListRequest withRow(Integer row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public Integer getRow() {
        return row;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    public MsGetLogListRequest withStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    /**
    * 起始日期
    * @return startDate
    **/
    @ApiModelProperty(value = "起始日期")


    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public MsGetLogListRequest withTypeId(String typeId) {
        this.typeId = typeId;
        return this;
    }

    /**
    * 业务主键ID
    * @return typeId
    **/
    @ApiModelProperty(value = "业务主键ID")


    public String getTypeId() {
        return typeId;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetLogListRequest msGetLogListRequest = (MsGetLogListRequest) o;
        return Objects.equals(this.appid, msGetLogListRequest.appid) &&
            Objects.equals(this.doType, msGetLogListRequest.doType) &&
            Objects.equals(this.endDate, msGetLogListRequest.endDate) &&
            Objects.equals(this.groupId, msGetLogListRequest.groupId) &&
            Objects.equals(this.logType, msGetLogListRequest.logType) &&
            Objects.equals(this.operateName, msGetLogListRequest.operateName) &&
            Objects.equals(this.page, msGetLogListRequest.page) &&
            Objects.equals(this.rid, msGetLogListRequest.rid) &&
            Objects.equals(this.row, msGetLogListRequest.row) &&
            Objects.equals(this.startDate, msGetLogListRequest.startDate) &&
            Objects.equals(this.typeId, msGetLogListRequest.typeId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, doType, endDate, groupId, logType, operateName, page, rid, row, startDate, typeId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetLogListRequest }.
     */
    public static MsGetLogListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetLogListRequest.class);
    }
}

