package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetMenuResourceListByUserRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("resourcesetIds")
    @Valid
    private List<Long> resourcesetIds = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("roleId")
    private String roleId = null;

    @JsonProperty("userId")
    private String userId = null;

    public MsGetMenuResourceListByUserRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetMenuResourceListByUserRequest withResourcesetIds(List<Long> resourcesetIds) {
        this.resourcesetIds = resourcesetIds;
        return this;
    }

    public MsGetMenuResourceListByUserRequest withResourcesetIdsAdd(Long resourcesetIds) {
        if (this.resourcesetIds == null) {
            this.resourcesetIds = new ArrayList<Long>();
        }
        this.resourcesetIds.add(resourcesetIds);
        return this;
    }

    /**
    * 功能集Id
    * @return resourcesetIds
    **/
    @ApiModelProperty(value = "功能集Id")


    public List<Long> getResourcesetIds() {
        return resourcesetIds;
    }

    public void setResourcesetIds(List<Long> resourcesetIds) {
        this.resourcesetIds = resourcesetIds;
    }

    public MsGetMenuResourceListByUserRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetMenuResourceListByUserRequest withRoleId(String roleId) {
        this.roleId = roleId;
        return this;
    }

    /**
    * 角色Id
    * @return roleId
    **/
    @ApiModelProperty(value = "角色Id")


    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public MsGetMenuResourceListByUserRequest withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    /**
    * 用户Id
    * @return userId
    **/
    @ApiModelProperty(value = "用户Id")


    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetMenuResourceListByUserRequest msGetMenuResourceListByUserRequest = (MsGetMenuResourceListByUserRequest) o;
        return Objects.equals(this.appid, msGetMenuResourceListByUserRequest.appid) &&
            Objects.equals(this.resourcesetIds, msGetMenuResourceListByUserRequest.resourcesetIds) &&
            Objects.equals(this.rid, msGetMenuResourceListByUserRequest.rid) &&
            Objects.equals(this.roleId, msGetMenuResourceListByUserRequest.roleId) &&
            Objects.equals(this.userId, msGetMenuResourceListByUserRequest.userId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, resourcesetIds, rid, roleId, userId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetMenuResourceListByUserRequest }.
     */
    public static MsGetMenuResourceListByUserRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetMenuResourceListByUserRequest.class);
    }
}

