package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetOpenApiUserListRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("openapiUserObject")
    private String openapiUserObject = null;

    @JsonProperty("page")
    private Integer page = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private Integer row = null;

    @JsonProperty("status")
    private String status = null;

    @JsonProperty("userCode")
    private String userCode = null;

    public MsGetOpenApiUserListRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetOpenApiUserListRequest withOpenapiUserObject(String openapiUserObject) {
        this.openapiUserObject = openapiUserObject;
        return this;
    }

    /**
    * openApi用户对象
    * @return openapiUserObject
    **/
    @ApiModelProperty(value = "openApi用户对象")


    public String getOpenapiUserObject() {
        return openapiUserObject;
    }

    public void setOpenapiUserObject(String openapiUserObject) {
        this.openapiUserObject = openapiUserObject;
    }

    public MsGetOpenApiUserListRequest withPage(Integer page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public MsGetOpenApiUserListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetOpenApiUserListRequest withRow(Integer row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public Integer getRow() {
        return row;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    public MsGetOpenApiUserListRequest withStatus(String status) {
        this.status = status;
        return this;
    }

    /**
    * 用户状态
    * @return status
    **/
    @ApiModelProperty(value = "用户状态")


    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public MsGetOpenApiUserListRequest withUserCode(String userCode) {
        this.userCode = userCode;
        return this;
    }

    /**
    * 用户编码
    * @return userCode
    **/
    @ApiModelProperty(value = "用户编码")


    public String getUserCode() {
        return userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetOpenApiUserListRequest msGetOpenApiUserListRequest = (MsGetOpenApiUserListRequest) o;
        return Objects.equals(this.appid, msGetOpenApiUserListRequest.appid) &&
            Objects.equals(this.openapiUserObject, msGetOpenApiUserListRequest.openapiUserObject) &&
            Objects.equals(this.page, msGetOpenApiUserListRequest.page) &&
            Objects.equals(this.rid, msGetOpenApiUserListRequest.rid) &&
            Objects.equals(this.row, msGetOpenApiUserListRequest.row) &&
            Objects.equals(this.status, msGetOpenApiUserListRequest.status) &&
            Objects.equals(this.userCode, msGetOpenApiUserListRequest.userCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, openapiUserObject, page, rid, row, status, userCode);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetOpenApiUserListRequest }.
     */
    public static MsGetOpenApiUserListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetOpenApiUserListRequest.class);
    }
}

