package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetOrgStructDetailRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("checkParamFlag")
    private Boolean checkParamFlag = null;

    @JsonProperty("companyId")
    private Long companyId = null;

    @JsonProperty("groupId")
    private Long groupId = null;

    @JsonProperty("orgCode")
    private String orgCode = null;

    @JsonProperty("orgName")
    private String orgName = null;

    @JsonProperty("orgStructId")
    private Long orgStructId = null;

    @JsonProperty("parentId")
    private Long parentId = null;

    @JsonProperty("rid")
    private String rid = null;

    public MsGetOrgStructDetailRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetOrgStructDetailRequest withCheckParamFlag(Boolean checkParamFlag) {
        this.checkParamFlag = checkParamFlag;
        return this;
    }

    /**
    * 是否是名称/其他 参数验证
    * @return checkParamFlag
    **/
    @ApiModelProperty(example = "false", value = "是否是名称/其他 参数验证")


    public Boolean isgetCheckParamFlag() {
        return checkParamFlag;
    }

    public void setCheckParamFlag(Boolean checkParamFlag) {
        this.checkParamFlag = checkParamFlag;
    }

    public MsGetOrgStructDetailRequest withCompanyId(Long companyId) {
        this.companyId = companyId;
        return this;
    }

    /**
    * companyId
    * @return companyId
    **/
    @ApiModelProperty(value = "companyId")


    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public MsGetOrgStructDetailRequest withGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * groupId
    * @return groupId
    **/
    @ApiModelProperty(value = "groupId")


    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public MsGetOrgStructDetailRequest withOrgCode(String orgCode) {
        this.orgCode = orgCode;
        return this;
    }

    /**
    * 组织机构代码
    * @return orgCode
    **/
    @ApiModelProperty(value = "组织机构代码")


    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public MsGetOrgStructDetailRequest withOrgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    /**
    * 组织机构名称
    * @return orgName
    **/
    @ApiModelProperty(value = "组织机构名称")


    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public MsGetOrgStructDetailRequest withOrgStructId(Long orgStructId) {
        this.orgStructId = orgStructId;
        return this;
    }

    /**
    * ID
    * @return orgStructId
    **/
    @ApiModelProperty(value = "ID")


    public Long getOrgStructId() {
        return orgStructId;
    }

    public void setOrgStructId(Long orgStructId) {
        this.orgStructId = orgStructId;
    }

    public MsGetOrgStructDetailRequest withParentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    /**
    * parentId
    * @return parentId
    **/
    @ApiModelProperty(value = "parentId")


    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public MsGetOrgStructDetailRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetOrgStructDetailRequest msGetOrgStructDetailRequest = (MsGetOrgStructDetailRequest) o;
        return Objects.equals(this.appid, msGetOrgStructDetailRequest.appid) &&
            Objects.equals(this.checkParamFlag, msGetOrgStructDetailRequest.checkParamFlag) &&
            Objects.equals(this.companyId, msGetOrgStructDetailRequest.companyId) &&
            Objects.equals(this.groupId, msGetOrgStructDetailRequest.groupId) &&
            Objects.equals(this.orgCode, msGetOrgStructDetailRequest.orgCode) &&
            Objects.equals(this.orgName, msGetOrgStructDetailRequest.orgName) &&
            Objects.equals(this.orgStructId, msGetOrgStructDetailRequest.orgStructId) &&
            Objects.equals(this.parentId, msGetOrgStructDetailRequest.parentId) &&
            Objects.equals(this.rid, msGetOrgStructDetailRequest.rid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, checkParamFlag, companyId, groupId, orgCode, orgName, orgStructId, parentId, rid);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetOrgStructDetailRequest }.
     */
    public static MsGetOrgStructDetailRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetOrgStructDetailRequest.class);
    }
}

