package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetOrgStructListRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("auditStatus")
    private Integer auditStatus = null;

    @JsonProperty("excludeCompanyId")
    private Long excludeCompanyId = null;

    @JsonProperty("excludeCurrAndSubsByOrgStructId")
    private Long excludeCurrAndSubsByOrgStructId = null;

    @JsonProperty("groupId")
    private Long groupId = null;

    @JsonProperty("orgCodeName")
    private String orgCodeName = null;

    @JsonProperty("orgStructIds")
    @Valid
    private List<Long> orgStructIds = null;

    @JsonProperty("orgType")
    private Integer orgType = null;

    @JsonProperty("page")
    private Integer page = null;

    @JsonProperty("queryBelongToCountFlag")
    private Boolean queryBelongToCountFlag = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private Integer row = null;

    @JsonProperty("singleOrgType")
    private Integer singleOrgType = null;

    @JsonProperty("status")
    private Integer status = null;

    @JsonProperty("statusTime")
    private String statusTime = null;

    @JsonProperty("userId")
    private Long userId = null;

    public MsGetOrgStructListRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetOrgStructListRequest withAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
        return this;
    }

    /**
    * 公司审核状态：0待审核，1审核通过,2审核拒绝
    * @return auditStatus
    **/
    @ApiModelProperty(value = "公司审核状态：0待审核，1审核通过,2审核拒绝")


    public Integer getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public MsGetOrgStructListRequest withExcludeCompanyId(Long excludeCompanyId) {
        this.excludeCompanyId = excludeCompanyId;
        return this;
    }

    /**
    * 查询排除公司id
    * @return excludeCompanyId
    **/
    @ApiModelProperty(value = "查询排除公司id")


    public Long getExcludeCompanyId() {
        return excludeCompanyId;
    }

    public void setExcludeCompanyId(Long excludeCompanyId) {
        this.excludeCompanyId = excludeCompanyId;
    }

    public MsGetOrgStructListRequest withExcludeCurrAndSubsByOrgStructId(Long excludeCurrAndSubsByOrgStructId) {
        this.excludeCurrAndSubsByOrgStructId = excludeCurrAndSubsByOrgStructId;
        return this;
    }

    /**
    * 查询排除当前节点及以下节点id集合
    * @return excludeCurrAndSubsByOrgStructId
    **/
    @ApiModelProperty(value = "查询排除当前节点及以下节点id集合")


    public Long getExcludeCurrAndSubsByOrgStructId() {
        return excludeCurrAndSubsByOrgStructId;
    }

    public void setExcludeCurrAndSubsByOrgStructId(Long excludeCurrAndSubsByOrgStructId) {
        this.excludeCurrAndSubsByOrgStructId = excludeCurrAndSubsByOrgStructId;
    }

    public MsGetOrgStructListRequest withGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 集团id
    * @return groupId
    **/
    @ApiModelProperty(value = "集团id")


    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public MsGetOrgStructListRequest withOrgCodeName(String orgCodeName) {
        this.orgCodeName = orgCodeName;
        return this;
    }

    /**
    * 组织代码名称
    * @return orgCodeName
    **/
    @ApiModelProperty(value = "组织代码名称")


    public String getOrgCodeName() {
        return orgCodeName;
    }

    public void setOrgCodeName(String orgCodeName) {
        this.orgCodeName = orgCodeName;
    }

    public MsGetOrgStructListRequest withOrgStructIds(List<Long> orgStructIds) {
        this.orgStructIds = orgStructIds;
        return this;
    }

    public MsGetOrgStructListRequest withOrgStructIdsAdd(Long orgStructIds) {
        if (this.orgStructIds == null) {
            this.orgStructIds = new ArrayList<Long>();
        }
        this.orgStructIds.add(orgStructIds);
        return this;
    }

    /**
    * 组织机构id集合
    * @return orgStructIds
    **/
    @ApiModelProperty(value = "组织机构id集合")


    public List<Long> getOrgStructIds() {
        return orgStructIds;
    }

    public void setOrgStructIds(List<Long> orgStructIds) {
        this.orgStructIds = orgStructIds;
    }

    public MsGetOrgStructListRequest withOrgType(Integer orgType) {
        this.orgType = orgType;
        return this;
    }

    /**
    * 组织类型-微服务用于多个过滤(组织类型 0；集团 1：公司 2：其他组织)
    * @return orgType
    **/
    @ApiModelProperty(value = "组织类型-微服务用于多个过滤(组织类型 0；集团 1：公司 2：其他组织)")


    public Integer getOrgType() {
        return orgType;
    }

    public void setOrgType(Integer orgType) {
        this.orgType = orgType;
    }

    public MsGetOrgStructListRequest withPage(Integer page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public MsGetOrgStructListRequest withQueryBelongToCountFlag(Boolean queryBelongToCountFlag) {
        this.queryBelongToCountFlag = queryBelongToCountFlag;
        return this;
    }

    /**
    * 是否查询下属人数
    * @return queryBelongToCountFlag
    **/
    @ApiModelProperty(example = "false", value = "是否查询下属人数")


    public Boolean isgetQueryBelongToCountFlag() {
        return queryBelongToCountFlag;
    }

    public void setQueryBelongToCountFlag(Boolean queryBelongToCountFlag) {
        this.queryBelongToCountFlag = queryBelongToCountFlag;
    }

    public MsGetOrgStructListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetOrgStructListRequest withRow(Integer row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public Integer getRow() {
        return row;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    public MsGetOrgStructListRequest withSingleOrgType(Integer singleOrgType) {
        this.singleOrgType = singleOrgType;
        return this;
    }

    /**
    * 组织类型-用于微服务单个过滤(组织类型 0；集团 1：公司 2：其他组织)
    * @return singleOrgType
    **/
    @ApiModelProperty(value = "组织类型-用于微服务单个过滤(组织类型 0；集团 1：公司 2：其他组织)")


    public Integer getSingleOrgType() {
        return singleOrgType;
    }

    public void setSingleOrgType(Integer singleOrgType) {
        this.singleOrgType = singleOrgType;
    }

    public MsGetOrgStructListRequest withStatus(Integer status) {
        this.status = status;
        return this;
    }

    /**
    * 状态
    * @return status
    **/
    @ApiModelProperty(value = "状态")


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public MsGetOrgStructListRequest withStatusTime(String statusTime) {
        this.statusTime = statusTime;
        return this;
    }

    /**
    * 状态变更时间
    * @return statusTime
    **/
    @ApiModelProperty(value = "状态变更时间")


    public String getStatusTime() {
        return statusTime;
    }

    public void setStatusTime(String statusTime) {
        this.statusTime = statusTime;
    }

    public MsGetOrgStructListRequest withUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    /**
    * 用户id
    * @return userId
    **/
    @ApiModelProperty(value = "用户id")


    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetOrgStructListRequest msGetOrgStructListRequest = (MsGetOrgStructListRequest) o;
        return Objects.equals(this.appid, msGetOrgStructListRequest.appid) &&
            Objects.equals(this.auditStatus, msGetOrgStructListRequest.auditStatus) &&
            Objects.equals(this.excludeCompanyId, msGetOrgStructListRequest.excludeCompanyId) &&
            Objects.equals(this.excludeCurrAndSubsByOrgStructId, msGetOrgStructListRequest.excludeCurrAndSubsByOrgStructId) &&
            Objects.equals(this.groupId, msGetOrgStructListRequest.groupId) &&
            Objects.equals(this.orgCodeName, msGetOrgStructListRequest.orgCodeName) &&
            Objects.equals(this.orgStructIds, msGetOrgStructListRequest.orgStructIds) &&
            Objects.equals(this.orgType, msGetOrgStructListRequest.orgType) &&
            Objects.equals(this.page, msGetOrgStructListRequest.page) &&
            Objects.equals(this.queryBelongToCountFlag, msGetOrgStructListRequest.queryBelongToCountFlag) &&
            Objects.equals(this.rid, msGetOrgStructListRequest.rid) &&
            Objects.equals(this.row, msGetOrgStructListRequest.row) &&
            Objects.equals(this.singleOrgType, msGetOrgStructListRequest.singleOrgType) &&
            Objects.equals(this.status, msGetOrgStructListRequest.status) &&
            Objects.equals(this.statusTime, msGetOrgStructListRequest.statusTime) &&
            Objects.equals(this.userId, msGetOrgStructListRequest.userId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, auditStatus, excludeCompanyId, excludeCurrAndSubsByOrgStructId, groupId, orgCodeName, orgStructIds, orgType, page, queryBelongToCountFlag, rid, row, singleOrgType, status, statusTime, userId);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetOrgStructListRequest }.
     */
    public static MsGetOrgStructListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetOrgStructListRequest.class);
    }
}

