package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetOrgStructTreeRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("excludeCompanyId")
    private Long excludeCompanyId = null;

    @JsonProperty("groupId")
    private Long groupId = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("status")
    private Integer status = null;

    public MsGetOrgStructTreeRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetOrgStructTreeRequest withExcludeCompanyId(Long excludeCompanyId) {
        this.excludeCompanyId = excludeCompanyId;
        return this;
    }

    /**
    * 查询排除公司id
    * @return excludeCompanyId
    **/
    @ApiModelProperty(value = "查询排除公司id")


    public Long getExcludeCompanyId() {
        return excludeCompanyId;
    }

    public void setExcludeCompanyId(Long excludeCompanyId) {
        this.excludeCompanyId = excludeCompanyId;
    }

    public MsGetOrgStructTreeRequest withGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 集团id
    * @return groupId
    **/
    @ApiModelProperty(value = "集团id")


    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public MsGetOrgStructTreeRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetOrgStructTreeRequest withStatus(Integer status) {
        this.status = status;
        return this;
    }

    /**
    * org 启用状态
    * @return status
    **/
    @ApiModelProperty(value = "org 启用状态")


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetOrgStructTreeRequest msGetOrgStructTreeRequest = (MsGetOrgStructTreeRequest) o;
        return Objects.equals(this.appid, msGetOrgStructTreeRequest.appid) &&
            Objects.equals(this.excludeCompanyId, msGetOrgStructTreeRequest.excludeCompanyId) &&
            Objects.equals(this.groupId, msGetOrgStructTreeRequest.groupId) &&
            Objects.equals(this.rid, msGetOrgStructTreeRequest.rid) &&
            Objects.equals(this.status, msGetOrgStructTreeRequest.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, excludeCompanyId, groupId, rid, status);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetOrgStructTreeRequest }.
     */
    public static MsGetOrgStructTreeRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetOrgStructTreeRequest.class);
    }
}

