package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetOrgSubListRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("companyId")
    private Long companyId = null;

    @JsonProperty("groupId")
    private Long groupId = null;

    @JsonProperty("orgName")
    private String orgName = null;

    @JsonProperty("rid")
    private String rid = null;

    public MsGetOrgSubListRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetOrgSubListRequest withCompanyId(Long companyId) {
        this.companyId = companyId;
        return this;
    }

    /**
    * 公司id
    * @return companyId
    **/
    @ApiModelProperty(value = "公司id")


    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public MsGetOrgSubListRequest withGroupId(Long groupId) {
        this.groupId = groupId;
        return this;
    }

    /**
    * 组织机构id
    * @return groupId
    **/
    @ApiModelProperty(value = "组织机构id")


    public Long getGroupId() {
        return groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public MsGetOrgSubListRequest withOrgName(String orgName) {
        this.orgName = orgName;
        return this;
    }

    /**
    * 组织名称
    * @return orgName
    **/
    @ApiModelProperty(value = "组织名称")


    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public MsGetOrgSubListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetOrgSubListRequest msGetOrgSubListRequest = (MsGetOrgSubListRequest) o;
        return Objects.equals(this.appid, msGetOrgSubListRequest.appid) &&
            Objects.equals(this.companyId, msGetOrgSubListRequest.companyId) &&
            Objects.equals(this.groupId, msGetOrgSubListRequest.groupId) &&
            Objects.equals(this.orgName, msGetOrgSubListRequest.orgName) &&
            Objects.equals(this.rid, msGetOrgSubListRequest.rid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, companyId, groupId, orgName, rid);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetOrgSubListRequest }.
     */
    public static MsGetOrgSubListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetOrgSubListRequest.class);
    }
}

