package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetResourceDetailRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("checkParamFlag")
    private Boolean checkParamFlag = null;

    @JsonProperty("parentId")
    private Long parentId = null;

    @JsonProperty("resourceCode")
    private String resourceCode = null;

    @JsonProperty("resourceId")
    private Long resourceId = null;

    @JsonProperty("resourceName")
    private String resourceName = null;

    @JsonProperty("rid")
    private String rid = null;

    public MsGetResourceDetailRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetResourceDetailRequest withCheckParamFlag(Boolean checkParamFlag) {
        this.checkParamFlag = checkParamFlag;
        return this;
    }

    /**
    * 是否是名称/其他 参数验证
    * @return checkParamFlag
    **/
    @ApiModelProperty(example = "false", value = "是否是名称/其他 参数验证")


    public Boolean isgetCheckParamFlag() {
        return checkParamFlag;
    }

    public void setCheckParamFlag(Boolean checkParamFlag) {
        this.checkParamFlag = checkParamFlag;
    }

    public MsGetResourceDetailRequest withParentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    /**
    * 资源码父节点id
    * @return parentId
    **/
    @ApiModelProperty(value = "资源码父节点id")


    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public MsGetResourceDetailRequest withResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
        return this;
    }

    /**
    * 资源码Code
    * @return resourceCode
    **/
    @ApiModelProperty(value = "资源码Code")


    public String getResourceCode() {
        return resourceCode;
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
    }

    public MsGetResourceDetailRequest withResourceId(Long resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
    * ID
    * @return resourceId
    **/
    @ApiModelProperty(value = "ID")


    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public MsGetResourceDetailRequest withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    /**
    * 资源码名称
    * @return resourceName
    **/
    @ApiModelProperty(value = "资源码名称")


    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public MsGetResourceDetailRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetResourceDetailRequest msGetResourceDetailRequest = (MsGetResourceDetailRequest) o;
        return Objects.equals(this.appid, msGetResourceDetailRequest.appid) &&
            Objects.equals(this.checkParamFlag, msGetResourceDetailRequest.checkParamFlag) &&
            Objects.equals(this.parentId, msGetResourceDetailRequest.parentId) &&
            Objects.equals(this.resourceCode, msGetResourceDetailRequest.resourceCode) &&
            Objects.equals(this.resourceId, msGetResourceDetailRequest.resourceId) &&
            Objects.equals(this.resourceName, msGetResourceDetailRequest.resourceName) &&
            Objects.equals(this.rid, msGetResourceDetailRequest.rid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, checkParamFlag, parentId, resourceCode, resourceId, resourceName, rid);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetResourceDetailRequest }.
     */
    public static MsGetResourceDetailRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetResourceDetailRequest.class);
    }
}

