package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetResourceListRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("page")
    private Integer page = null;

    @JsonProperty("querySubResourceFlag")
    private Boolean querySubResourceFlag = null;

    @JsonProperty("resourceCode")
    private String resourceCode = null;

    @JsonProperty("resourceName")
    private String resourceName = null;

    @JsonProperty("resourcePlatform")
    private Integer resourcePlatform = null;

    @JsonProperty("resourceType")
    private Integer resourceType = null;

    @JsonProperty("rid")
    private String rid = null;

    @JsonProperty("row")
    private Integer row = null;

    public MsGetResourceListRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetResourceListRequest withPage(Integer page) {
        this.page = page;
        return this;
    }

    /**
    * 当前页
    * @return page
    **/
    @ApiModelProperty(value = "当前页")


    public Integer getPage() {
        return page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public MsGetResourceListRequest withQuerySubResourceFlag(Boolean querySubResourceFlag) {
        this.querySubResourceFlag = querySubResourceFlag;
        return this;
    }

    /**
    * 是否查询下级列表
    * @return querySubResourceFlag
    **/
    @ApiModelProperty(example = "false", value = "是否查询下级列表")


    public Boolean isgetQuerySubResourceFlag() {
        return querySubResourceFlag;
    }

    public void setQuerySubResourceFlag(Boolean querySubResourceFlag) {
        this.querySubResourceFlag = querySubResourceFlag;
    }

    public MsGetResourceListRequest withResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
        return this;
    }

    /**
    * 资源码
    * @return resourceCode
    **/
    @ApiModelProperty(value = "资源码")


    public String getResourceCode() {
        return resourceCode;
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
    }

    public MsGetResourceListRequest withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    /**
    * 资源码名称
    * @return resourceName
    **/
    @ApiModelProperty(value = "资源码名称")


    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public MsGetResourceListRequest withResourcePlatform(Integer resourcePlatform) {
        this.resourcePlatform = resourcePlatform;
        return this;
    }

    /**
    * 资源码所属平台 0:进项 1:销项 2:权限 3:公共 4:其他
    * @return resourcePlatform
    **/
    @ApiModelProperty(value = "资源码所属平台 0:进项 1:销项 2:权限 3:公共 4:其他")


    public Integer getResourcePlatform() {
        return resourcePlatform;
    }

    public void setResourcePlatform(Integer resourcePlatform) {
        this.resourcePlatform = resourcePlatform;
    }

    public MsGetResourceListRequest withResourceType(Integer resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    /**
    * 资源码类型： 0:url 1:模块 2:操作 3:页面
    * @return resourceType
    **/
    @ApiModelProperty(value = "资源码类型： 0:url 1:模块 2:操作 3:页面")


    public Integer getResourceType() {
        return resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public MsGetResourceListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    public MsGetResourceListRequest withRow(Integer row) {
        this.row = row;
        return this;
    }

    /**
    * 每页显示行数
    * @return row
    **/
    @ApiModelProperty(value = "每页显示行数")


    public Integer getRow() {
        return row;
    }

    public void setRow(Integer row) {
        this.row = row;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetResourceListRequest msGetResourceListRequest = (MsGetResourceListRequest) o;
        return Objects.equals(this.appid, msGetResourceListRequest.appid) &&
            Objects.equals(this.page, msGetResourceListRequest.page) &&
            Objects.equals(this.querySubResourceFlag, msGetResourceListRequest.querySubResourceFlag) &&
            Objects.equals(this.resourceCode, msGetResourceListRequest.resourceCode) &&
            Objects.equals(this.resourceName, msGetResourceListRequest.resourceName) &&
            Objects.equals(this.resourcePlatform, msGetResourceListRequest.resourcePlatform) &&
            Objects.equals(this.resourceType, msGetResourceListRequest.resourceType) &&
            Objects.equals(this.rid, msGetResourceListRequest.rid) &&
            Objects.equals(this.row, msGetResourceListRequest.row);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, page, querySubResourceFlag, resourceCode, resourceName, resourcePlatform, resourceType, rid, row);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetResourceListRequest }.
     */
    public static MsGetResourceListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetResourceListRequest.class);
    }
}

