package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetResourceSubListRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("resourceId")
    private Long resourceId = null;

    @JsonProperty("rid")
    private String rid = null;

    public MsGetResourceSubListRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetResourceSubListRequest withResourceId(Long resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
    * 资源码Id
    * @return resourceId
    **/
    @ApiModelProperty(value = "资源码Id")


    public Long getResourceId() {
        return resourceId;
    }

    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    public MsGetResourceSubListRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetResourceSubListRequest msGetResourceSubListRequest = (MsGetResourceSubListRequest) o;
        return Objects.equals(this.appid, msGetResourceSubListRequest.appid) &&
            Objects.equals(this.resourceId, msGetResourceSubListRequest.resourceId) &&
            Objects.equals(this.rid, msGetResourceSubListRequest.rid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, resourceId, rid);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetResourceSubListRequest }.
     */
    public static MsGetResourceSubListRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetResourceSubListRequest.class);
    }
}

