package org.yiwan.seiya.phoenix.ucenter.service.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-03-16T17:43:09.515+08:00")
public class MsGetResourcesetDetailRequest   {
    @JsonProperty("appid")
    private String appid = null;

    @JsonProperty("hasResourceList")
    private Boolean hasResourceList = null;

    @JsonProperty("resourcesetId")
    private Long resourcesetId = null;

    @JsonProperty("rid")
    private String rid = null;

    public MsGetResourcesetDetailRequest withAppid(String appid) {
        this.appid = appid;
        return this;
    }

    /**
    * 请求应用ID
    * @return appid
    **/
    @ApiModelProperty(required = true, value = "请求应用ID")
  @NotNull


    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public MsGetResourcesetDetailRequest withHasResourceList(Boolean hasResourceList) {
        this.hasResourceList = hasResourceList;
        return this;
    }

    /**
    * 是否包含资源码列表
    * @return hasResourceList
    **/
    @ApiModelProperty(example = "false", value = "是否包含资源码列表")


    public Boolean isgetHasResourceList() {
        return hasResourceList;
    }

    public void setHasResourceList(Boolean hasResourceList) {
        this.hasResourceList = hasResourceList;
    }

    public MsGetResourcesetDetailRequest withResourcesetId(Long resourcesetId) {
        this.resourcesetId = resourcesetId;
        return this;
    }

    /**
    * ID
    * @return resourcesetId
    **/
    @ApiModelProperty(value = "ID")


    public Long getResourcesetId() {
        return resourcesetId;
    }

    public void setResourcesetId(Long resourcesetId) {
        this.resourcesetId = resourcesetId;
    }

    public MsGetResourcesetDetailRequest withRid(String rid) {
        this.rid = rid;
        return this;
    }

    /**
    * 请求ID
    * @return rid
    **/
    @ApiModelProperty(required = true, value = "请求ID")
  @NotNull


    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MsGetResourcesetDetailRequest msGetResourcesetDetailRequest = (MsGetResourcesetDetailRequest) o;
        return Objects.equals(this.appid, msGetResourcesetDetailRequest.appid) &&
            Objects.equals(this.hasResourceList, msGetResourcesetDetailRequest.hasResourceList) &&
            Objects.equals(this.resourcesetId, msGetResourcesetDetailRequest.resourcesetId) &&
            Objects.equals(this.rid, msGetResourcesetDetailRequest.rid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appid, hasResourceList, resourcesetId, rid);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link MsGetResourcesetDetailRequest }.
     */
    public static MsGetResourcesetDetailRequest fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, MsGetResourcesetDetailRequest.class);
    }
}

